/*
 * Decompiled with CFR 0.152.
 */
package walnoot.libgdxutils.input;

import com.badlogic.gdx.Gdx;
import com.badlogic.gdx.Input;
import com.badlogic.gdx.utils.IntArray;
import com.badlogic.gdx.utils.Json;
import com.badlogic.gdx.utils.JsonValue;

public class Key
implements Json.Serializable {
    private final IntArray keyCodes = new IntArray();
    private String name;
    private boolean justTouched;

    public Key(String name, int ... keyCodes) {
        this.name = name;
        this.keyCodes.addAll(keyCodes);
    }

    public Key() {
    }

    public boolean contains(int keyCode) {
        int i = 0;
        while (i < this.keyCodes.size) {
            if (this.keyCodes.get(i) == keyCode) {
                return true;
            }
            ++i;
        }
        return false;
    }

    public void addKeyCode(int keyCode) {
        this.keyCodes.add(keyCode);
    }

    public String getName() {
        return this.name;
    }

    public boolean isJustTouched() {
        return this.justTouched;
    }

    public void setJustTouched(boolean justTouched) {
        this.justTouched = justTouched;
    }

    public boolean isTouched() {
        int i = 0;
        while (i < this.keyCodes.size) {
            if (Gdx.input.isKeyPressed(this.keyCodes.get(i))) {
                return true;
            }
            ++i;
        }
        return false;
    }

    @Override
    public void write(Json json) {
        json.writeValue("name", this.name);
        json.writeArrayStart("keycodes");
        int i = 0;
        while (i < this.keyCodes.size) {
            json.writeValue(Input.Keys.toString(this.keyCodes.get(i)));
            ++i;
        }
        json.writeArrayEnd();
    }

    @Override
    public void read(Json json, JsonValue jsonData) {
        this.name = jsonData.getString("name");
        JsonValue keys = jsonData.get("keycodes");
        int i = 0;
        while (i < keys.size) {
            this.addKeyCode(Input.Keys.valueOf(keys.getString(i)));
            ++i;
        }
    }
}

