/*
 * Decompiled with CFR 0.152.
 */
package walnoot.libgdxutils;

import com.badlogic.gdx.Gdx;
import com.badlogic.gdx.graphics.Color;
import com.badlogic.gdx.graphics.OrthographicCamera;
import com.badlogic.gdx.graphics.Pixmap;
import com.badlogic.gdx.graphics.Texture;
import com.badlogic.gdx.graphics.g2d.SpriteBatch;
import com.badlogic.gdx.graphics.g2d.TextureRegion;
import com.badlogic.gdx.graphics.glutils.FrameBuffer;
import com.badlogic.gdx.graphics.glutils.ShaderProgram;

public class BlurEffect {
    private static final float BLUR_FACTOR = 4.0f;
    private FrameBuffer blurTargetA;
    private FrameBuffer blurTargetB;
    private TextureRegion fboRegion;
    private ShaderProgram shader;
    private SpriteBatch batch = new SpriteBatch(1);
    private OrthographicCamera cam;
    private int dirLocation;
    float downScale = 16.0f;
    private FrameBuffer target;
    private Color tint = Color.WHITE;

    public void create() {
        this.shader = new ShaderProgram(Gdx.files.classpath("walnoot/libgdxutils/shaders/default.vertex"), Gdx.files.classpath("walnoot/libgdxutils/shaders/blur.fragment"));
        if (this.shader.getLog().length() != 0) {
            System.out.println(this.shader.getLog());
        }
        this.dirLocation = this.shader.getUniformLocation("dir");
    }

    private void resizeBatch(int width, int height) {
        this.cam.setToOrtho(false, width, height);
        this.batch.setProjectionMatrix(this.cam.combined);
    }

    public void begin(FrameBuffer target) {
        if (this.isActive()) {
            throw new IllegalStateException("Need to call end() before begin()");
        }
        this.target = target;
        this.blurTargetA.begin();
        this.batch.setShader(null);
        this.resizeBatch(Gdx.graphics.getWidth(), Gdx.graphics.getHeight());
        this.batch.begin();
    }

    public void end() {
        this.batch.flush();
        this.blurTargetA.end();
        this.genMipMaps(this.blurTargetA);
        this.batch.setShader(this.shader);
        this.shader.setUniformf(this.dirLocation, 4.0f * this.downScale / (float)Gdx.graphics.getWidth(), 0.0f);
        this.blurTargetB.begin();
        this.fboRegion.setTexture(this.blurTargetA.getColorBufferTexture());
        this.batch.draw(this.fboRegion, 0.0f, 0.0f);
        this.batch.flush();
        if (this.target == null) {
            this.blurTargetB.end();
        } else {
            this.target.begin();
        }
        this.resizeBatch(Gdx.graphics.getWidth(), Gdx.graphics.getHeight());
        this.shader.setUniformf(this.dirLocation, 0.0f, 4.0f * this.downScale / (float)Gdx.graphics.getWidth());
        this.fboRegion.setTexture(this.blurTargetB.getColorBufferTexture());
        this.batch.setColor(this.tint);
        this.batch.draw(this.fboRegion, 0.0f, 0.0f);
        this.batch.setColor(Color.WHITE);
        this.batch.setShader(null);
        this.batch.end();
        this.target = null;
    }

    private void genMipMaps(FrameBuffer buffer) {
        buffer.getColorBufferTexture().bind();
        Gdx.gl20.glGenerateMipmap(3553);
    }

    public void resize(int width, int height) {
        if (this.blurTargetA != null) {
            this.blurTargetA.dispose();
        }
        if (this.blurTargetB != null) {
            this.blurTargetB.dispose();
        }
        this.blurTargetA = new MipMapFrameBuffer(Pixmap.Format.RGBA8888, width, height, true);
        this.blurTargetB = new FrameBuffer(Pixmap.Format.RGBA8888, (int)((float)width / this.downScale), (int)((float)width / this.downScale), false);
        this.fboRegion = new TextureRegion(this.blurTargetA.getColorBufferTexture());
        this.fboRegion.flip(false, true);
        this.cam = new OrthographicCamera(Gdx.graphics.getWidth(), Gdx.graphics.getHeight());
        this.cam.setToOrtho(false);
    }

    public void setTint(Color tint) {
        this.tint = tint;
    }

    public void dispose() {
        this.blurTargetA.dispose();
        this.blurTargetB.dispose();
        this.shader.dispose();
    }

    public boolean isActive() {
        return this.target != null;
    }

    public FrameBuffer getRenderTarget() {
        return this.blurTargetA;
    }

    private class MipMapFrameBuffer
    extends FrameBuffer {
        public MipMapFrameBuffer(Pixmap.Format format, int width, int height, boolean hasDepth) {
            super(format, width, height, hasDepth);
        }

        @Override
        protected void setupTexture() {
            this.colorTexture = new Texture(this.width, this.height, this.format);
            this.colorTexture.setFilter(Texture.TextureFilter.MipMapLinearLinear, Texture.TextureFilter.Linear);
            this.colorTexture.setWrap(Texture.TextureWrap.ClampToEdge, Texture.TextureWrap.ClampToEdge);
        }
    }
}

