/*
 * Decompiled with CFR 0.152.
 */
package walnoot.ld31.entities;

import com.badlogic.gdx.graphics.Color;
import com.badlogic.gdx.graphics.g2d.Sprite;
import com.badlogic.gdx.graphics.g2d.SpriteBatch;
import walnoot.ld31.LD31Game;
import walnoot.ld31.entities.CollidableEntity;

public abstract class SpriteEntity
extends CollidableEntity {
    protected Sprite sprite;
    private float alpha = 1.0f;
    private float scale = 1.0f;

    public SpriteEntity(LD31Game game) {
        super(game);
    }

    public SpriteEntity(LD31Game game, String spriteName) {
        super(game);
        this.setSprite(spriteName);
    }

    @Override
    public void render(SpriteBatch batch) {
        this.sprite.setSize(this.getWidth() * this.scale, this.getHeight() * this.scale);
        this.sprite.setOrigin(this.getWidth() * this.scale / 2.0f, this.getHeight() * this.scale / 2.0f);
        this.sprite.setPosition(this.pos.x - this.sprite.getOriginX(), this.pos.y - this.sprite.getOriginY());
        this.sprite.setColor(this.getColor());
        this.sprite.draw(batch, this.alpha);
    }

    public void setSprite(String name) {
        this.sprite = new Sprite(this.game.getTextureManager().get(name));
    }

    protected Color getColor() {
        return Color.WHITE;
    }

    public void setAlpha(float alpha) {
        this.alpha = alpha;
    }

    public void setScale(float scale) {
        this.scale = scale;
    }
}

