/*
 * Decompiled with CFR 0.152.
 */
package walnoot.ld31.entities;

import com.badlogic.gdx.Gdx;
import com.badlogic.gdx.graphics.OrthographicCamera;
import com.badlogic.gdx.graphics.Pixmap;
import com.badlogic.gdx.graphics.Texture;
import com.badlogic.gdx.graphics.g2d.Sprite;
import com.badlogic.gdx.graphics.g2d.SpriteBatch;
import com.badlogic.gdx.graphics.glutils.FrameBuffer;
import walnoot.ld31.LD31Game;
import walnoot.ld31.World;
import walnoot.ld31.entities.SpriteEntity;

public class PortalEntity
extends SpriteEntity {
    private static final int FBO_SIZE = 512;
    public static final int ZOOM_TIME = 60;
    private World nextWorld;
    private FrameBuffer frameBuffer;
    private int zoomTimer;

    public PortalEntity(LD31Game game, World nextWorld, float x, float y) {
        super(game);
        this.nextWorld = nextWorld;
        this.pos.set(x, y);
    }

    @Override
    public void update() {
        if (this.world.getPlayer().pos.dst2(this.pos) < 0.25f) {
            ++this.zoomTimer;
            if (this.zoomTimer > 60) {
                this.zoomTimer = 60;
            }
        } else if (this.zoomTimer > 0) {
            --this.zoomTimer;
        }
    }

    private void renderWorld() {
        this.frameBuffer = new FrameBuffer(Pixmap.Format.RGBA8888, 512, 512, false);
        this.frameBuffer.begin();
        OrthographicCamera camera = new OrthographicCamera(2.0f, 2.0f);
        camera.zoom = 6.5f;
        camera.update();
        SpriteBatch batch = new SpriteBatch();
        batch.setProjectionMatrix(camera.combined);
        batch.begin();
        this.nextWorld.render(batch, false);
        batch.end();
        this.frameBuffer.end();
        this.frameBuffer.getColorBufferTexture().bind();
        Gdx.gl20.glGenerateMipmap(3553);
        this.frameBuffer.getColorBufferTexture().setFilter(Texture.TextureFilter.MipMapLinearLinear, Texture.TextureFilter.Linear);
        this.sprite = new Sprite(this.frameBuffer.getColorBufferTexture());
        this.sprite.flip(false, true);
    }

    @Override
    public boolean isSolid() {
        return false;
    }

    @Override
    public int getLevel() {
        return -1;
    }

    public int getZoomTimer() {
        return this.zoomTimer;
    }

    public World getNextWorld() {
        return this.nextWorld;
    }

    @Override
    public void show() {
        this.renderWorld();
    }

    @Override
    public void hide() {
        this.frameBuffer.dispose();
        this.frameBuffer = null;
    }
}

