/*
 * Decompiled with CFR 0.152.
 */
package walnoot.ld31.entities;

import com.badlogic.gdx.graphics.Color;
import com.badlogic.gdx.graphics.g2d.Sprite;
import com.badlogic.gdx.graphics.g2d.SpriteBatch;
import com.badlogic.gdx.math.Vector2;
import walnoot.ld31.GameState;
import walnoot.ld31.LD31Game;
import walnoot.ld31.ScanCallback;
import walnoot.ld31.entities.CollidableEntity;
import walnoot.ld31.entities.EnemyEntity;
import walnoot.ld31.entities.HealthEntity;
import walnoot.ld31.entities.MachineEntity;
import walnoot.ld31.entities.SwitchEntity;

public class PlayerEntity
extends HealthEntity
implements ScanCallback {
    private static final float SPEED = 4.0f;
    private static final int ATTACK_TIME = 15;
    private Vector2 tmp = new Vector2();
    private int attackTicks;
    private Sprite sword;
    private Vector2 attackDir = new Vector2(0.0f, 1.0f);
    private int coins;
    public GameState state;

    public PlayerEntity(LD31Game game) {
        super(game, "hero", 10);
        this.sword = new Sprite(game.getTextureManager().get("sword"));
        this.sword.setSize(1.0f, 1.0f);
        this.sword.setOrigin(0.5f, 0.0f);
    }

    @Override
    public void update() {
        super.update();
        this.tmp.set(0.0f, 0.0f);
        if (this.game.getInput().getKey("left").isTouched()) {
            this.tmp.x -= 1.0f;
        }
        if (this.game.getInput().getKey("right").isTouched()) {
            this.tmp.x += 1.0f;
        }
        if (this.game.getInput().getKey("down").isTouched()) {
            this.tmp.y -= 1.0f;
        }
        if (this.game.getInput().getKey("up").isTouched()) {
            this.tmp.y += 1.0f;
        }
        this.tmp.nor();
        if (!this.tmp.isZero()) {
            this.attackDir.set(this.tmp);
        }
        this.tmp.scl(4.0f);
        this.vel.add(this.tmp);
        if (this.isAttacking()) {
            --this.attackTicks;
            this.world.scanRegion(this.getX1() + this.attackDir.x, this.getY1() + this.attackDir.y, this.getX2() + this.attackDir.x, this.getY2() + this.attackDir.y, this);
        } else if (this.game.getInput().getKey("attack").isJustTouched()) {
            this.attackTicks = 15;
        }
    }

    @Override
    public void render(SpriteBatch batch) {
        float angle = (this.attackDir.getAngleRad() - 1.5707964f) * 57.295776f;
        if (this.isAttacking()) {
            angle += (2.0f * (float)this.attackTicks / 15.0f - 1.0f) * 90.0f;
        }
        this.sword.setRotation(angle);
        this.tmp.set(this.attackDir).scl(this.isAttacking() ? 0.25f : -0.25f).add(this.pos).sub(0.5f, 0.0f);
        this.sword.setPosition(this.tmp.x, this.tmp.y);
        if (!this.state.isZooming()) {
            this.sword.draw(batch);
        }
        super.render(batch);
    }

    @Override
    public void reportEntity(CollidableEntity e) {
        if (e != this && e instanceof HealthEntity) {
            HealthEntity healthEntity = (HealthEntity)e;
            healthEntity.damage(1);
            e.vel.add(this.tmp.set(this.attackDir).scl(3.0f));
        }
        if (e instanceof SwitchEntity) {
            ((SwitchEntity)e).hit();
        }
        if (e instanceof MachineEntity && this.attackTicks == 0 && this.coins > 0 && this.getHealth() < this.getMaxHealth()) {
            this.heal(1);
            --this.coins;
        }
    }

    @Override
    public void onHit(CollidableEntity other) {
        if (other instanceof EnemyEntity) {
            this.damage(1);
            this.vel.add(this.tmp.set(other.vel).scl(10.0f));
        }
    }

    public boolean isAttacking() {
        return this.attackTicks > 0;
    }

    @Override
    public float getWidth() {
        return 0.8f;
    }

    @Override
    public float getHeight() {
        return 0.8f;
    }

    @Override
    protected Color getColor() {
        return this.isInvulnerable() ? Color.RED : Color.WHITE;
    }

    public void addCoins(int amount) {
        this.coins += amount;
    }

    public int getCoins() {
        return this.coins;
    }
}

