/*
 * Decompiled with CFR 0.152.
 */
package walnoot.ld31.entities;

import walnoot.ld31.LD31Game;
import walnoot.ld31.entities.SpriteEntity;

public class HealthEntity
extends SpriteEntity {
    private static final int INVULNERABILITY_TIME = 15;
    private int health;
    private int maxHealth;
    private int invulnerabilityTicks;

    public HealthEntity(LD31Game game, String spriteName, int maxHealth) {
        super(game, spriteName);
        this.maxHealth = maxHealth;
        this.health = maxHealth;
    }

    @Override
    public void update() {
        if (this.isInvulnerable()) {
            --this.invulnerabilityTicks;
        }
    }

    public void damage(int amount) {
        if (!this.isInvulnerable()) {
            this.health -= amount;
            this.onDamage();
            if (this.health <= 0) {
                this.health = 0;
                this.remove();
            }
            this.invulnerabilityTicks = 15;
        }
    }

    protected void onDamage() {
    }

    public void heal(int amount) {
        this.health += amount;
        if (this.health > this.maxHealth) {
            this.health = this.maxHealth;
        }
    }

    public int getHealth() {
        return this.health;
    }

    public int getMaxHealth() {
        return this.maxHealth;
    }

    public boolean isInvulnerable() {
        return this.invulnerabilityTicks > 0;
    }

    public void setMaxHealth(int maxHealth) {
        this.maxHealth = maxHealth;
    }
}

