/*
 * Decompiled with CFR 0.152.
 */
package walnoot.ld31.entities;

import com.badlogic.gdx.math.Vector2;
import walnoot.ld31.LD31Game;
import walnoot.ld31.entities.Entity;

public abstract class CollidableEntity
extends Entity {
    public Vector2 vel = new Vector2();

    public CollidableEntity(LD31Game game) {
        super(game);
    }

    public float getWidth() {
        return 1.0f;
    }

    public float getHeight() {
        return 1.0f;
    }

    public boolean hits(CollidableEntity c2) {
        return this.getX1() < c2.getX2() && this.getX2() > c2.getX1() && this.getY1() < c2.getY2() && this.getY2() > c2.getY1();
    }

    public boolean hits(float x1, float y1, float x2, float y2) {
        return this.getX1() < x2 && this.getX2() > x1 && this.getY1() < y2 && this.getY2() > y1;
    }

    public final float getX1() {
        return this.pos.x - this.getWidth() / 2.0f;
    }

    public final float getX2() {
        return this.pos.x + this.getWidth() / 2.0f;
    }

    public final float getY1() {
        return this.pos.y - this.getHeight() / 2.0f;
    }

    public final float getY2() {
        return this.pos.y + this.getHeight() / 2.0f;
    }

    public boolean isMovable() {
        return true;
    }

    public boolean isSolid() {
        return true;
    }

    public void onHit(CollidableEntity other) {
    }
}

