/*
 * Decompiled with CFR 0.152.
 */
package walnoot.ld31;

import com.badlogic.gdx.graphics.g2d.SpriteBatch;
import com.badlogic.gdx.utils.Array;
import walnoot.ld31.LD31Game;
import walnoot.ld31.ScanCallback;
import walnoot.ld31.entities.CollidableEntity;
import walnoot.ld31.entities.Entity;
import walnoot.ld31.entities.PlayerEntity;
import walnoot.ld31.entities.PortalEntity;

public class World {
    public static final int SIZE = 6;
    private Array<Entity> entities = new Array();
    private Array<Entity> removedEntities = new Array();
    private Array<CollidableEntity> collidables = new Array();
    private PlayerEntity player;
    private World upperWorld;
    private boolean filled;
    private boolean goUp;

    public World(LD31Game game) {
    }

    public void update() {
        this.removedEntities.clear();
        int i = 0;
        while (i < this.entities.size) {
            Entity e = this.entities.get(i);
            if (e.isRemoved()) {
                this.removedEntities.add(e);
            } else {
                e.update();
            }
            ++i;
        }
        this.entities.removeAll(this.removedEntities, true);
        for (Entity e : this.removedEntities) {
            CollidableEntity c = (CollidableEntity)e;
            if (!this.collidables.contains(c, true)) continue;
            this.collidables.removeValue(c, true);
        }
        this.doPhysicsX();
        this.doPhysicsY();
        for (CollidableEntity e : this.collidables) {
            e.vel.set(0.0f, 0.0f);
        }
    }

    private void doPhysicsX() {
        int i = 0;
        while (i < this.collidables.size) {
            CollidableEntity c1 = this.collidables.get(i);
            c1.pos.x += c1.vel.x * 0.016666668f;
            int j = 0;
            while (j < this.collidables.size) {
                CollidableEntity c2 = this.collidables.get(j);
                if (c1 != c2 && c1.isMovable() && c1.hits(c2)) {
                    if (c1.vel.x > 0.0f) {
                        c1.pos.x = c2.getX1() - c1.getWidth() / 2.0f - 0.001f;
                    }
                    if (c1.vel.x < 0.0f) {
                        c1.pos.x = c2.getX2() + c1.getWidth() / 2.0f + 0.001f;
                    }
                    c1.onHit(c2);
                    c2.onHit(c1);
                }
                ++j;
            }
            ++i;
        }
    }

    private void doPhysicsY() {
        int i = 0;
        while (i < this.collidables.size) {
            CollidableEntity c1 = this.collidables.get(i);
            c1.pos.y += c1.vel.y * 0.016666668f;
            int j = 0;
            while (j < this.collidables.size) {
                CollidableEntity c2 = this.collidables.get(j);
                if (c1 != c2 && c1.isMovable() && c1.hits(c2)) {
                    if (c1.vel.y > 0.0f) {
                        c1.pos.y = c2.getY1() - c1.getHeight() / 2.0f - 0.001f;
                    }
                    if (c1.vel.y < 0.0f) {
                        c1.pos.y = c2.getY2() + c1.getHeight() / 2.0f + 0.001f;
                    }
                    c1.onHit(c2);
                    c2.onHit(c1);
                }
                ++j;
            }
            ++i;
        }
    }

    public void render(SpriteBatch batch, boolean drawPlayer) {
        this.entities.sort();
        int i = 0;
        while (i < this.entities.size) {
            Entity e = this.entities.get(i);
            if (!(!drawPlayer && e instanceof PlayerEntity || e.isRemoved())) {
                e.render(batch);
            }
            ++i;
        }
    }

    public void addEntity(Entity e) {
        CollidableEntity collidable;
        this.entities.add(e);
        e.world = this;
        if (e instanceof CollidableEntity && (collidable = (CollidableEntity)e).isSolid()) {
            this.collidables.add(collidable);
        }
        if (e instanceof PlayerEntity) {
            this.player = (PlayerEntity)e;
        }
    }

    public PlayerEntity getPlayer() {
        return this.player;
    }

    public PortalEntity getTargetPortal() {
        PortalEntity target = null;
        for (Entity e : this.entities) {
            if (!(e instanceof PortalEntity)) continue;
            PortalEntity portal = (PortalEntity)e;
            if (target != null && portal.getZoomTimer() <= target.getZoomTimer()) continue;
            target = portal;
        }
        return target;
    }

    public void scanRegion(float x1, float y1, float x2, float y2, ScanCallback callback) {
        int i = 0;
        while (i < this.collidables.size) {
            CollidableEntity e = this.collidables.get(i);
            if (e.hits(x1, y1, x2, y2)) {
                callback.reportEntity(e);
            }
            ++i;
        }
    }

    public void setUpperWorld(World upperWorld) {
        this.upperWorld = upperWorld;
    }

    public World getUpperWorld() {
        return this.upperWorld;
    }

    public void setFilled(boolean filled) {
        this.filled = filled;
    }

    public boolean isFilled() {
        return this.filled;
    }

    public void show() {
        for (Entity e : this.entities) {
            e.show();
        }
    }

    public void hide() {
        for (Entity e : this.entities) {
            e.hide();
        }
    }

    public Array<Entity> getEntities() {
        return this.entities;
    }

    public void goUpper() {
        this.goUp = true;
    }

    public boolean shouldGoUp() {
        return this.goUp;
    }

    public void setGoUp(boolean goUp) {
        this.goUp = goUp;
    }
}

