/*
 * Decompiled with CFR 0.152.
 */
package walnoot.ld31;

import com.badlogic.gdx.Gdx;
import com.badlogic.gdx.graphics.Color;
import com.badlogic.gdx.graphics.OrthographicCamera;
import com.badlogic.gdx.graphics.g2d.SpriteBatch;
import com.badlogic.gdx.graphics.g2d.TextureRegion;
import com.badlogic.gdx.graphics.glutils.FrameBuffer;
import walnoot.ld31.GameState;
import walnoot.ld31.LD31Game;
import walnoot.libgdxutils.State;
import walnoot.libgdxutils.Transition;

public class ImageState
extends State {
    private OrthographicCamera camera = new OrthographicCamera();
    private SpriteBatch batch = new SpriteBatch();
    private TextureRegion textureRegion;
    private LD31Game game;

    public ImageState(LD31Game game, boolean gameover) {
        this.game = game;
        this.textureRegion = gameover ? game.getTextureManager().get("gameover") : game.getTextureManager().get("intro");
    }

    @Override
    public void update() {
        if (Gdx.input.isKeyPressed(62)) {
            this.manager.transitionTo(new GameState(this.game), new Transition.FadeTransition(1.0f));
        }
    }

    @Override
    public void render(FrameBuffer target) {
        this.clearScreen(Color.BLACK);
        this.batch.begin();
        this.batch.draw(this.textureRegion, -1.0f, -1.0f, 2.0f, 2.0f);
        this.batch.end();
    }

    @Override
    public void resize(boolean creation, int width, int height) {
        this.camera.viewportWidth = 2.0f * (float)width / (float)height;
        this.camera.viewportHeight = 2.0f;
        this.camera.update();
        this.batch.setProjectionMatrix(this.camera.combined);
    }
}

