/*
 * Decompiled with CFR 0.152.
 */
package walnoot.ld31;

import com.badlogic.gdx.graphics.Color;
import com.badlogic.gdx.graphics.OrthographicCamera;
import com.badlogic.gdx.graphics.g2d.SpriteBatch;
import com.badlogic.gdx.graphics.g2d.TextureRegion;
import com.badlogic.gdx.graphics.glutils.FrameBuffer;
import com.badlogic.gdx.math.Interpolation;
import com.badlogic.gdx.math.MathUtils;
import com.badlogic.gdx.math.Vector2;
import walnoot.ld31.ImageState;
import walnoot.ld31.LD31Game;
import walnoot.ld31.World;
import walnoot.ld31.entities.CoinEntity;
import walnoot.ld31.entities.DoorEntity;
import walnoot.ld31.entities.EnemyEntity;
import walnoot.ld31.entities.Entity;
import walnoot.ld31.entities.LadderEntity;
import walnoot.ld31.entities.MachineEntity;
import walnoot.ld31.entities.PlayerEntity;
import walnoot.ld31.entities.PortalEntity;
import walnoot.ld31.entities.PrePortalEntity;
import walnoot.ld31.entities.SwitchEntity;
import walnoot.ld31.entities.WallEntity;
import walnoot.libgdxutils.State;
import walnoot.libgdxutils.Transition;

public class GameState
extends State {
    private static final float ICON_SCALE = 0.075f;
    private static final int SHAKE_TIME = 15;
    private OrthographicCamera gameCamera = new OrthographicCamera();
    private OrthographicCamera uiCamera = new OrthographicCamera();
    private SpriteBatch batch = new SpriteBatch();
    private World world;
    private Vector2 tmp = new Vector2();
    private LD31Game game;
    private TextureRegion heart;
    private TextureRegion heartGrey;
    private TextureRegion coin;
    private TextureRegion vignette;
    private int shakeTicks;

    public GameState(LD31Game game) {
        this(game, GameState.genWorld(null, game, 0), new PlayerEntity(game));
    }

    public GameState(LD31Game game, World world, PlayerEntity player) {
        this.game = game;
        this.world = world;
        player.pos.set(0.0f, 0.0f);
        player.state = this;
        player.world = world;
        if (!world.isFilled()) {
            world.addEntity(player);
            world.setFilled(true);
        }
        world.setGoUp(false);
        for (Entity e : world.getEntities()) {
            if (!(e instanceof PrePortalEntity)) continue;
            world.addEntity(new PortalEntity(game, GameState.genWorld(world, game, ((PrePortalEntity)e).getMetadata()), e.pos.x, e.pos.y));
            e.remove();
        }
        world.show();
        this.heart = game.getTextureManager().get("heart");
        this.heartGrey = game.getTextureManager().get("heart_grey");
        this.coin = game.getTextureManager().get("coin");
        this.vignette = game.getTextureManager().get("vignette");
    }

    private static World genWorld(World upper, LD31Game game, int metadata) {
        World world = new World(game);
        world.setUpperWorld(upper);
        int xOffset = 0;
        int yOffset = 0;
        if (metadata == 255) {
            yOffset = 13;
            xOffset = MathUtils.random(0, 3) * 13;
        }
        if (metadata == 128) {
            xOffset = MathUtils.random(0, 3) * 13;
            yOffset = 26;
        }
        int x = -6;
        while (x <= 6) {
            int y = -6;
            while (y <= 6) {
                int pixel = game.getLevels().getPixel(x + 6 + xOffset, -y + 6 + yOffset);
                if (pixel == 255) {
                    world.addEntity(new WallEntity(game, x, y));
                } else if (pixel == 0xFF00FF) {
                    world.addEntity(new CoinEntity(game, x, y));
                } else if (pixel == -16776961) {
                    world.addEntity(new EnemyEntity(game, x, (float)y));
                } else if ((pixel & 0xFFFFFF00) == 65280) {
                    world.addEntity(new DoorEntity(game, x, y, pixel & 0xFF));
                } else if ((pixel & 0xFFFFFF00) == -65536) {
                    world.addEntity(new PrePortalEntity(game, x, y, pixel & 0xFF));
                } else if (pixel == -8388353) {
                    world.addEntity(new LadderEntity(game, x, y));
                } else if (pixel == 0xFFFFFF) {
                    world.addEntity(new SwitchEntity(game, x, y));
                } else if (pixel == -16711681) {
                    world.addEntity(new MachineEntity(game, x, y));
                }
                ++y;
            }
            ++x;
        }
        return world;
    }

    @Override
    public void update() {
        this.world.update();
        PortalEntity portal = this.world.getTargetPortal();
        if (portal != null && portal.getZoomTimer() == 60) {
            this.manager.transitionTo(new GameState(this.game, portal.getNextWorld(), this.world.getPlayer()), new Transition.FadeTransition(0.5f));
        }
        if (this.world.shouldGoUp() && this.world.getUpperWorld() != null) {
            this.manager.setState(new GameState(this.game, this.world.getUpperWorld(), this.world.getPlayer()));
        }
        if (this.shakeTicks > 0) {
            --this.shakeTicks;
        }
        if (this.world.getPlayer().isInvulnerable() && this.shakeTicks == 0) {
            this.shakeTicks = 15;
        }
        if (this.world.getPlayer().isRemoved()) {
            this.manager.transitionTo(new ImageState(this.game, true), new Transition.FadeTransition(1.0f));
        }
    }

    @Override
    public void render(FrameBuffer target) {
        this.clearScreen(Color.DARK_GRAY);
        PortalEntity portal = this.world.getTargetPortal();
        PlayerEntity player = this.world.getPlayer();
        if (portal != null) {
            float alpha = (float)portal.getZoomTimer() / 60.0f;
            player.setAlpha(1.0f - alpha);
            player.setScale(1.0f - alpha);
            this.gameCamera.position.set(this.tmp.set(0.0f, 0.0f).lerp(portal.pos, alpha), 0.0f);
            this.gameCamera.zoom = Interpolation.linear.apply(6.5f, 0.5f, alpha * alpha);
        } else {
            this.gameCamera.position.set(0.0f, 0.0f, 0.0f);
            this.gameCamera.zoom = 6.5f;
            player.setAlpha(1.0f);
            player.setScale(1.0f);
        }
        this.gameCamera.position.add(MathUtils.random() * (float)this.shakeTicks / 15.0f, MathUtils.random() * (float)this.shakeTicks / 15.0f, 0.0f);
        this.gameCamera.update();
        this.batch.setProjectionMatrix(this.gameCamera.combined);
        this.batch.begin();
        this.world.render(this.batch, true);
        this.batch.setProjectionMatrix(this.uiCamera.combined);
        this.batch.draw(this.vignette, 0.0f, 0.0f, this.uiCamera.viewportWidth, 1.0f);
        int i = 0;
        while (i < player.getMaxHealth()) {
            if (i < player.getHealth()) {
                this.batch.draw(this.heart, (float)i * 0.075f * 0.5f + 0.01f, 0.01f, 0.075f, 0.075f);
            } else {
                this.batch.draw(this.heartGrey, (float)i * 0.075f * 0.5f + 0.01f, 0.01f, 0.075f, 0.075f);
            }
            ++i;
        }
        i = 0;
        while (i < player.getCoins()) {
            this.batch.draw(this.coin, 0.01f, (float)i * 0.075f * 0.125f + 0.075f, 0.075f, 0.075f);
            ++i;
        }
        this.batch.end();
    }

    public boolean isZooming() {
        PortalEntity portal = this.world.getTargetPortal();
        return portal == null ? false : portal.getZoomTimer() != 0;
    }

    @Override
    public void hide() {
        this.world.hide();
    }

    @Override
    public void resize(boolean creation, int width, int height) {
        this.gameCamera.viewportWidth = 2.0f * (float)width / (float)height;
        this.gameCamera.viewportHeight = 2.0f;
        this.uiCamera.setToOrtho(false, (float)width / (float)height, 1.0f);
        this.uiCamera.update();
    }
}

