/*
 * Decompiled with CFR 0.152.
 */
package com.badlogic.gdx.utils.viewport;

import com.badlogic.gdx.Gdx;
import com.badlogic.gdx.graphics.Camera;
import com.badlogic.gdx.math.Matrix4;
import com.badlogic.gdx.math.Rectangle;
import com.badlogic.gdx.math.Vector2;
import com.badlogic.gdx.math.Vector3;
import com.badlogic.gdx.math.collision.Ray;
import com.badlogic.gdx.scenes.scene2d.utils.ScissorStack;

public abstract class Viewport {
    protected float worldWidth;
    protected float worldHeight;
    protected int viewportWidth;
    protected int viewportHeight;
    protected int viewportX;
    protected int viewportY;
    protected Camera camera;
    private final Vector3 tmp = new Vector3();

    public final void update() {
        Gdx.gl.glViewport(this.viewportX, this.viewportY, this.viewportWidth, this.viewportHeight);
        this.camera.viewportWidth = this.worldWidth;
        this.camera.viewportHeight = this.worldHeight;
        this.camera.update();
    }

    public final void update(int screenWidth, int screenHeight) {
        this.update(screenWidth, screenHeight, false);
    }

    public void update(int screenWidth, int screenHeight, boolean centerCamera) {
        Gdx.gl.glViewport(this.viewportX, this.viewportY, this.viewportWidth, this.viewportHeight);
        this.camera.viewportWidth = this.worldWidth;
        this.camera.viewportHeight = this.worldHeight;
        if (centerCamera) {
            this.camera.position.set(this.worldWidth / 2.0f, this.worldHeight / 2.0f, 0.0f);
        }
        this.camera.update();
    }

    public Vector2 unproject(Vector2 screenCoords) {
        this.tmp.set(screenCoords.x, screenCoords.y, 1.0f);
        this.camera.unproject(this.tmp, this.viewportX, this.viewportY, this.viewportWidth, this.viewportHeight);
        screenCoords.set(this.tmp.x, this.tmp.y);
        return screenCoords;
    }

    public Vector2 project(Vector2 worldCoords) {
        this.tmp.set(worldCoords.x, worldCoords.y, 1.0f);
        this.camera.project(this.tmp, this.viewportX, this.viewportY, this.viewportWidth, this.viewportHeight);
        worldCoords.set(this.tmp.x, this.tmp.y);
        return worldCoords;
    }

    public Vector3 unproject(Vector3 screenCoords) {
        this.camera.unproject(screenCoords, this.viewportX, this.viewportY, this.viewportWidth, this.viewportHeight);
        return screenCoords;
    }

    public Vector3 project(Vector3 worldCoords) {
        this.camera.project(worldCoords, this.viewportX, this.viewportY, this.viewportWidth, this.viewportHeight);
        return worldCoords;
    }

    public Ray getPickRay(float screenX, float screenY) {
        return this.camera.getPickRay(screenX, screenY, this.viewportX, this.viewportY, this.viewportWidth, this.viewportHeight);
    }

    public void calculateScissors(Matrix4 batchTransform, Rectangle area, Rectangle scissor) {
        ScissorStack.calculateScissors(this.camera, this.viewportX, this.viewportY, this.viewportWidth, this.viewportHeight, batchTransform, area, scissor);
    }

    public Vector2 toScreenCoordinates(Vector2 worldCoords, Matrix4 transformMatrix) {
        this.tmp.set(worldCoords.x, worldCoords.y, 0.0f);
        this.tmp.mul(transformMatrix);
        this.camera.project(this.tmp);
        this.tmp.y = (float)Gdx.graphics.getHeight() - this.tmp.y;
        worldCoords.x = this.tmp.x;
        worldCoords.y = this.tmp.y;
        return worldCoords;
    }

    public Camera getCamera() {
        return this.camera;
    }

    public void setCamera(Camera camera) {
        this.camera = camera;
    }

    public void setWorldSize(float worldWidth, float worldHeight) {
        this.worldWidth = worldWidth;
        this.worldHeight = worldHeight;
    }

    public float getWorldWidth() {
        return this.worldWidth;
    }

    public void setWorldWidth(float worldWidth) {
        this.worldWidth = worldWidth;
    }

    public float getWorldHeight() {
        return this.worldHeight;
    }

    public void setWorldHeight(float worldHeight) {
        this.worldHeight = worldHeight;
    }

    public int getViewportX() {
        return this.viewportX;
    }

    public int getViewportY() {
        return this.viewportY;
    }

    public int getViewportWidth() {
        return this.viewportWidth;
    }

    public int getViewportHeight() {
        return this.viewportHeight;
    }

    public int getLeftGutterWidth() {
        return this.viewportX;
    }

    public int getRightGutterX() {
        return this.viewportX + this.viewportWidth;
    }

    public int getRightGutterWidth() {
        return Gdx.graphics.getWidth() - (this.viewportX + this.viewportWidth);
    }

    public int getBottomGutterHeight() {
        return this.viewportY;
    }

    public int getTopGutterY() {
        return this.viewportY + this.viewportHeight;
    }

    public int getTopGutterHeight() {
        return Gdx.graphics.getHeight() - (this.viewportY + this.viewportHeight);
    }
}

