/*
 * Decompiled with CFR 0.152.
 */
package com.badlogic.gdx.utils.viewport;

import com.badlogic.gdx.graphics.Camera;
import com.badlogic.gdx.graphics.OrthographicCamera;
import com.badlogic.gdx.utils.viewport.Viewport;

public class ScreenViewport
extends Viewport {
    private float unitsPerPixel = 1.0f;

    public ScreenViewport() {
        this(new OrthographicCamera());
    }

    public ScreenViewport(Camera camera) {
        this.camera = camera;
    }

    @Override
    public void update(int screenWidth, int screenHeight, boolean centerCamera) {
        this.viewportX = 0;
        this.viewportY = 0;
        this.viewportWidth = screenWidth;
        this.viewportHeight = screenHeight;
        this.worldWidth = (float)screenWidth * this.unitsPerPixel;
        this.worldHeight = (float)screenHeight * this.unitsPerPixel;
        super.update(screenWidth, screenHeight, centerCamera);
    }

    public float getUnitsPerPixel() {
        return this.unitsPerPixel;
    }

    public void setUnitsPerPixel(float unitsPerPixel) {
        this.unitsPerPixel = unitsPerPixel;
    }
}

