/*
 * Decompiled with CFR 0.152.
 */
package com.badlogic.gdx.utils.viewport;

import com.badlogic.gdx.graphics.Camera;
import com.badlogic.gdx.graphics.OrthographicCamera;
import com.badlogic.gdx.math.Vector2;
import com.badlogic.gdx.utils.Scaling;
import com.badlogic.gdx.utils.viewport.Viewport;

public class ScalingViewport
extends Viewport {
    private Scaling scaling;

    public ScalingViewport(Scaling scaling, float worldWidth, float worldHeight) {
        this(scaling, worldWidth, worldHeight, new OrthographicCamera());
    }

    public ScalingViewport(Scaling scaling, float worldWidth, float worldHeight, Camera camera) {
        this.scaling = scaling;
        this.worldWidth = worldWidth;
        this.worldHeight = worldHeight;
        this.camera = camera;
    }

    @Override
    public void update(int screenWidth, int screenHeight, boolean centerCamera) {
        Vector2 scaled = this.scaling.apply(this.worldWidth, this.worldHeight, screenWidth, screenHeight);
        this.viewportWidth = Math.round(scaled.x);
        this.viewportHeight = Math.round(scaled.y);
        this.viewportX = (screenWidth - this.viewportWidth) / 2;
        this.viewportY = (screenHeight - this.viewportHeight) / 2;
        super.update(screenWidth, screenHeight, centerCamera);
    }

    public Scaling getScaling() {
        return this.scaling;
    }

    public void setScaling(Scaling scaling) {
        this.scaling = scaling;
    }
}

