/*
 * Decompiled with CFR 0.152.
 */
package com.badlogic.gdx.scenes.scene2d.utils;

import com.badlogic.gdx.Gdx;
import com.badlogic.gdx.scenes.scene2d.utils.Selection;
import com.badlogic.gdx.scenes.scene2d.utils.UIUtils;
import com.badlogic.gdx.utils.Array;

public class ArraySelection<T>
extends Selection<T> {
    private Array<T> items;
    private boolean rangeSelect = true;

    public ArraySelection(Array<T> items) {
        this.items = items;
    }

    @Override
    public void choose(T item) {
        if (item == null) {
            throw new IllegalArgumentException("item cannot be null.");
        }
        if (this.isDisabled) {
            return;
        }
        if (this.selected.size > 0 && this.rangeSelect && this.multiple && (Gdx.input.isKeyPressed(59) || Gdx.input.isKeyPressed(60))) {
            int high;
            int low = this.items.indexOf(this.getLastSelected(), false);
            if (low > (high = this.items.indexOf(item, false))) {
                int temp = low;
                low = high;
                high = temp;
            }
            this.snapshot();
            if (!UIUtils.ctrl()) {
                this.selected.clear();
            }
            while (low <= high) {
                this.selected.add(this.items.get(low));
                ++low;
            }
            if (this.fireChangeEvent()) {
                this.revert();
            }
            this.cleanup();
            return;
        }
        super.choose(item);
    }

    public boolean getRangeSelect() {
        return this.rangeSelect;
    }

    public void setRangeSelect(boolean rangeSelect) {
        this.rangeSelect = rangeSelect;
    }
}

