/*
 * Decompiled with CFR 0.152.
 */
package com.badlogic.gdx.scenes.scene2d.ui;

import com.badlogic.gdx.math.Rectangle;
import com.badlogic.gdx.scenes.scene2d.Actor;
import com.badlogic.gdx.scenes.scene2d.Group;
import com.badlogic.gdx.scenes.scene2d.ui.Table;
import com.badlogic.gdx.scenes.scene2d.ui.TableLayout;
import com.badlogic.gdx.scenes.scene2d.utils.Layout;
import com.badlogic.gdx.utils.Array;
import com.badlogic.gdx.utils.Pool;
import com.esotericsoftware.tablelayout.BaseTableLayout;
import com.esotericsoftware.tablelayout.Cell;
import com.esotericsoftware.tablelayout.Toolkit;

public class TableToolkit
extends Toolkit<Actor, Table, TableLayout> {
    static boolean drawDebug;
    static Pool<Cell> cellPool;

    @Override
    public Cell obtainCell(TableLayout layout) {
        Cell cell = cellPool.obtain();
        cell.setLayout(layout);
        return cell;
    }

    @Override
    public void freeCell(Cell cell) {
        cell.free();
        cellPool.free(cell);
    }

    @Override
    public void addChild(Actor parent, Actor child) {
        child.remove();
        ((Group)parent).addActor(child);
    }

    @Override
    public void removeChild(Actor parent, Actor child) {
        ((Group)parent).removeActor(child);
    }

    @Override
    public float getMinWidth(Actor actor) {
        if (actor instanceof Layout) {
            return ((Layout)((Object)actor)).getMinWidth();
        }
        return actor.getWidth();
    }

    @Override
    public float getMinHeight(Actor actor) {
        if (actor instanceof Layout) {
            return ((Layout)((Object)actor)).getMinHeight();
        }
        return actor.getHeight();
    }

    @Override
    public float getPrefWidth(Actor actor) {
        if (actor instanceof Layout) {
            return ((Layout)((Object)actor)).getPrefWidth();
        }
        return actor.getWidth();
    }

    @Override
    public float getPrefHeight(Actor actor) {
        if (actor instanceof Layout) {
            return ((Layout)((Object)actor)).getPrefHeight();
        }
        return actor.getHeight();
    }

    @Override
    public float getMaxWidth(Actor actor) {
        if (actor instanceof Layout) {
            return ((Layout)((Object)actor)).getMaxWidth();
        }
        return 0.0f;
    }

    @Override
    public float getMaxHeight(Actor actor) {
        if (actor instanceof Layout) {
            return ((Layout)((Object)actor)).getMaxHeight();
        }
        return 0.0f;
    }

    @Override
    public float getWidth(Actor widget) {
        return widget.getWidth();
    }

    @Override
    public float getHeight(Actor widget) {
        return widget.getHeight();
    }

    @Override
    public void clearDebugRectangles(TableLayout layout) {
        if (layout.debugRects != null) {
            layout.debugRects.clear();
        }
    }

    @Override
    public void addDebugRectangle(TableLayout layout, BaseTableLayout.Debug type, float x, float y, float w, float h) {
        drawDebug = true;
        if (layout.debugRects == null) {
            layout.debugRects = new Array();
        }
        layout.debugRects.add(new DebugRect(type, x, ((Table)layout.getTable()).getHeight() - y, w, h));
    }

    static {
        cellPool = new Pool(){

            protected Cell newObject() {
                return new Cell();
            }
        };
    }

    static class DebugRect
    extends Rectangle {
        final BaseTableLayout.Debug type;

        public DebugRect(BaseTableLayout.Debug type, float x, float y, float width, float height) {
            super(x, y, width, height);
            this.type = type;
        }
    }
}

