/*
 * Decompiled with CFR 0.152.
 */
package com.badlogic.gdx.scenes.scene2d.ui;

import com.badlogic.gdx.graphics.Color;
import com.badlogic.gdx.graphics.g2d.Batch;
import com.badlogic.gdx.scenes.scene2d.Actor;
import com.badlogic.gdx.scenes.scene2d.Touchable;
import com.badlogic.gdx.scenes.scene2d.ui.WidgetGroup;
import com.badlogic.gdx.scenes.scene2d.utils.Drawable;
import com.badlogic.gdx.scenes.scene2d.utils.Layout;

public class Container
extends WidgetGroup {
    private Actor widget;
    private Float minWidth;
    private Float minHeight;
    private Float prefWidth;
    private Float prefHeight;
    private Float maxWidth;
    private Float maxHeight;
    private float padTop;
    private float padLeft;
    private float padBottom;
    private float padRight;
    private float fillX;
    private float fillY;
    private int align;
    private Drawable background;
    private boolean clip;
    private boolean round = true;

    public Container() {
        this.setTouchable(Touchable.childrenOnly);
        this.setTransform(false);
    }

    public Container(Actor widget) {
        this();
        this.setWidget(widget);
    }

    @Override
    public void draw(Batch batch, float parentAlpha) {
        this.validate();
        if (this.widget == null) {
            return;
        }
        if (this.isTransform()) {
            this.applyTransform(batch, this.computeTransform());
            this.drawBackground(batch, parentAlpha, 0.0f, 0.0f);
            if (this.clip) {
                boolean draw;
                batch.flush();
                boolean bl = draw = this.background == null ? this.clipBegin(0.0f, 0.0f, this.getWidth(), this.getHeight()) : this.clipBegin(this.padLeft, this.padBottom, this.getWidth() - this.padLeft - this.padRight, this.getHeight() - this.padBottom - this.padTop);
                if (draw) {
                    this.drawChildren(batch, parentAlpha);
                    this.clipEnd();
                }
            } else {
                this.drawChildren(batch, parentAlpha);
            }
            this.resetTransform(batch);
        } else {
            this.drawBackground(batch, parentAlpha, this.getX(), this.getY());
            super.draw(batch, parentAlpha);
        }
    }

    protected void drawBackground(Batch batch, float parentAlpha, float x, float y) {
        if (this.background == null) {
            return;
        }
        Color color = this.getColor();
        batch.setColor(color.r, color.g, color.b, color.a * parentAlpha);
        this.background.draw(batch, x, y, this.getWidth(), this.getHeight());
    }

    public void setBackground(Drawable background) {
        if (this.background == background) {
            return;
        }
        this.background = background;
        if (background == null) {
            this.pad(0.0f);
        } else {
            this.pad(background.getTopHeight(), background.getLeftWidth(), background.getBottomHeight(), background.getRightWidth());
            this.invalidate();
        }
    }

    public Container background(Drawable background) {
        this.setBackground(background);
        return this;
    }

    public Drawable getBackground() {
        return this.background;
    }

    @Override
    public void layout() {
        float height;
        float maxHeight;
        float maxWidth;
        float prefHeight;
        float prefWidth;
        float minHeight;
        float minWidth;
        Layout layout;
        if (this.widget == null) {
            return;
        }
        float containerWidth = this.getWidth() - this.padLeft - this.padRight;
        float containerHeight = this.getHeight() - this.padTop - this.padBottom;
        Layout layout2 = layout = this.widget instanceof Layout ? (Layout)((Object)this.widget) : null;
        if (layout != null) {
            minWidth = this.minWidth == null ? layout.getMinWidth() : this.minWidth.floatValue();
            minHeight = this.minHeight == null ? layout.getMinHeight() : this.minHeight.floatValue();
            prefWidth = this.prefWidth == null ? layout.getPrefWidth() : this.prefWidth.floatValue();
            prefHeight = this.prefHeight == null ? layout.getPrefHeight() : this.prefHeight.floatValue();
            maxWidth = this.maxWidth == null ? layout.getMaxWidth() : this.maxWidth.floatValue();
            maxHeight = this.maxHeight == null ? layout.getMaxHeight() : this.maxHeight.floatValue();
        } else {
            minWidth = this.minWidth == null ? this.widget.getWidth() : this.minWidth.floatValue();
            minHeight = this.minHeight == null ? this.widget.getHeight() : this.minHeight.floatValue();
            prefWidth = this.prefWidth == null ? this.widget.getWidth() : this.prefWidth.floatValue();
            prefHeight = this.prefHeight == null ? this.widget.getHeight() : this.prefHeight.floatValue();
            maxWidth = this.maxWidth == null ? this.widget.getWidth() : this.maxWidth.floatValue();
            maxHeight = this.maxHeight == null ? this.widget.getHeight() : this.maxHeight.floatValue();
        }
        float width = this.fillX > 0.0f ? containerWidth * this.fillX : Math.min(prefWidth, containerWidth);
        if (width < minWidth) {
            width = minWidth;
        }
        if (maxWidth > 0.0f && width > maxWidth) {
            width = maxWidth;
        }
        if ((height = this.fillY > 0.0f ? containerHeight * this.fillY : Math.min(prefHeight, containerHeight)) < minHeight) {
            height = minHeight;
        }
        if (maxHeight > 0.0f && height > maxHeight) {
            height = maxHeight;
        }
        float x = this.padLeft;
        if ((this.align & 0x10) != 0) {
            x += containerWidth - width;
        } else if ((this.align & 8) == 0) {
            x += (containerWidth - width) / 2.0f;
        }
        float y = this.padBottom;
        if ((this.align & 2) != 0) {
            y += containerHeight - height;
        } else if ((this.align & 4) == 0) {
            y += (containerHeight - height) / 2.0f;
        }
        if (this.round) {
            x = Math.round(x);
            y = Math.round(y);
            width = Math.round(width);
            height = Math.round(height);
        }
        this.widget.setBounds(x, y, width, height);
        if (this.widget instanceof Layout) {
            ((Layout)((Object)this.widget)).validate();
        }
    }

    public void setWidget(Actor widget) {
        if (widget == this) {
            throw new IllegalArgumentException("widget cannot be the Container.");
        }
        if (this.widget != null) {
            super.removeActor(this.widget);
        }
        this.widget = widget;
        if (widget != null) {
            super.addActor(widget);
        }
    }

    public Actor getWidget() {
        return this.widget;
    }

    @Override
    public void addActor(Actor actor) {
        throw new UnsupportedOperationException("Use Container#setWidget.");
    }

    @Override
    public void addActorAt(int index, Actor actor) {
        throw new UnsupportedOperationException("Use Container#setWidget.");
    }

    @Override
    public void addActorBefore(Actor actorBefore, Actor actor) {
        throw new UnsupportedOperationException("Use Container#setWidget.");
    }

    @Override
    public void addActorAfter(Actor actorAfter, Actor actor) {
        throw new UnsupportedOperationException("Use Container#setWidget.");
    }

    @Override
    public boolean removeActor(Actor actor) {
        if (actor != this.widget) {
            return false;
        }
        this.setWidget(null);
        return true;
    }

    public Container size(float size) {
        this.minWidth = Float.valueOf(size);
        this.minHeight = Float.valueOf(size);
        this.prefWidth = Float.valueOf(size);
        this.prefHeight = Float.valueOf(size);
        this.maxWidth = Float.valueOf(size);
        this.maxHeight = Float.valueOf(size);
        return this;
    }

    public Container size(float width, float height) {
        this.minWidth = Float.valueOf(width);
        this.minHeight = Float.valueOf(height);
        this.prefWidth = Float.valueOf(width);
        this.prefHeight = Float.valueOf(height);
        this.maxWidth = Float.valueOf(width);
        this.maxHeight = Float.valueOf(height);
        return this;
    }

    public Container width(float width) {
        this.minWidth = Float.valueOf(width);
        this.prefWidth = Float.valueOf(width);
        this.maxWidth = Float.valueOf(width);
        return this;
    }

    public Container height(float height) {
        this.minHeight = Float.valueOf(height);
        this.prefHeight = Float.valueOf(height);
        this.maxHeight = Float.valueOf(height);
        return this;
    }

    public Container minSize(float size) {
        this.minWidth = Float.valueOf(size);
        this.minHeight = Float.valueOf(size);
        return this;
    }

    public Container minSize(float width, float height) {
        this.minWidth = Float.valueOf(width);
        this.minHeight = Float.valueOf(height);
        return this;
    }

    public Container minWidth(float minWidth) {
        this.minWidth = Float.valueOf(minWidth);
        return this;
    }

    public Container minHeight(float minHeight) {
        this.minHeight = Float.valueOf(minHeight);
        return this;
    }

    public Container prefSize(float size) {
        this.prefWidth = Float.valueOf(size);
        this.prefHeight = Float.valueOf(size);
        return this;
    }

    public Container prefSize(float width, float height) {
        this.prefWidth = Float.valueOf(width);
        this.prefHeight = Float.valueOf(height);
        return this;
    }

    public Container prefWidth(float prefWidth) {
        this.prefWidth = Float.valueOf(prefWidth);
        return this;
    }

    public Container prefHeight(float prefHeight) {
        this.prefHeight = Float.valueOf(prefHeight);
        return this;
    }

    public Container maxSize(float size) {
        this.maxWidth = Float.valueOf(size);
        this.maxHeight = Float.valueOf(size);
        return this;
    }

    public Container maxSize(float width, float height) {
        this.maxWidth = Float.valueOf(width);
        this.maxHeight = Float.valueOf(height);
        return this;
    }

    public Container maxWidth(float maxWidth) {
        this.maxWidth = Float.valueOf(maxWidth);
        return this;
    }

    public Container maxHeight(float maxHeight) {
        this.maxHeight = Float.valueOf(maxHeight);
        return this;
    }

    public Container pad(float pad) {
        this.padTop = pad;
        this.padLeft = pad;
        this.padBottom = pad;
        this.padRight = pad;
        return this;
    }

    public Container pad(float top, float left, float bottom, float right) {
        this.padTop = top;
        this.padLeft = left;
        this.padBottom = bottom;
        this.padRight = right;
        return this;
    }

    public Container padTop(float padTop) {
        this.padTop = padTop;
        return this;
    }

    public Container padLeft(float padLeft) {
        this.padLeft = padLeft;
        return this;
    }

    public Container padBottom(float padBottom) {
        this.padBottom = padBottom;
        return this;
    }

    public Container padRight(float padRight) {
        this.padRight = padRight;
        return this;
    }

    public Container fill() {
        this.fillX = 1.0f;
        this.fillY = 1.0f;
        return this;
    }

    public Container fillX() {
        this.fillX = 1.0f;
        return this;
    }

    public Container fillY() {
        this.fillY = 1.0f;
        return this;
    }

    public Container fill(float x, float y) {
        this.fillX = x;
        this.fillY = y;
        return this;
    }

    public Container fill(boolean x, boolean y) {
        this.fillX = x ? 1.0f : 0.0f;
        this.fillY = y ? 1.0f : 0.0f;
        return this;
    }

    public Container fill(boolean fill) {
        this.fillX = fill ? 1.0f : 0.0f;
        this.fillY = fill ? 1.0f : 0.0f;
        return this;
    }

    public Container align(int align) {
        this.align = align;
        return this;
    }

    public Container center() {
        this.align = 1;
        return this;
    }

    public Container top() {
        this.align |= 2;
        this.align &= 0xFFFFFFFB;
        return this;
    }

    public Container left() {
        this.align |= 8;
        this.align &= 0xFFFFFFEF;
        return this;
    }

    public Container bottom() {
        this.align |= 4;
        this.align &= 0xFFFFFFFD;
        return this;
    }

    public Container right() {
        this.align |= 0x10;
        this.align &= 0xFFFFFFF7;
        return this;
    }

    @Override
    public float getMinWidth() {
        return (this.minWidth == null ? (this.widget instanceof Layout ? ((Layout)((Object)this.widget)).getMinWidth() : this.widget.getWidth()) : this.minWidth.floatValue()) + this.padLeft + this.padRight;
    }

    public Float getMinHeightValue() {
        return this.minHeight;
    }

    @Override
    public float getMinHeight() {
        return (this.minHeight == null ? (this.widget instanceof Layout ? ((Layout)((Object)this.widget)).getMinHeight() : this.widget.getHeight()) : this.minHeight.floatValue()) + this.padTop + this.padBottom;
    }

    public Float getPrefWidthValue() {
        return this.prefWidth;
    }

    @Override
    public float getPrefWidth() {
        float v;
        float f = this.prefWidth == null ? (this.widget instanceof Layout ? ((Layout)((Object)this.widget)).getPrefWidth() : this.widget.getWidth()) : (v = this.prefWidth.floatValue());
        if (this.background != null) {
            v = Math.max(v, this.background.getMinWidth());
        }
        return v + this.padLeft + this.padRight;
    }

    public Float getPrefHeightValue() {
        return this.prefHeight;
    }

    @Override
    public float getPrefHeight() {
        float v;
        float f = this.prefHeight == null ? (this.widget instanceof Layout ? ((Layout)((Object)this.widget)).getPrefHeight() : this.widget.getHeight()) : (v = this.prefHeight.floatValue());
        if (this.background != null) {
            v = Math.max(v, this.background.getMinHeight());
        }
        return v + this.padTop + this.padBottom;
    }

    public Float getMaxWidthValue() {
        return this.maxWidth;
    }

    @Override
    public float getMaxWidth() {
        float v;
        float f = this.maxWidth == null ? (this.widget instanceof Layout ? ((Layout)((Object)this.widget)).getMaxWidth() : this.widget.getWidth()) : (v = this.maxWidth.floatValue());
        if (v > 0.0f) {
            v += this.padLeft + this.padRight;
        }
        return v;
    }

    public Float getMaxHeightValue() {
        return this.maxHeight;
    }

    @Override
    public float getMaxHeight() {
        float v;
        float f = this.maxHeight == null ? (this.widget instanceof Layout ? ((Layout)((Object)this.widget)).getMaxHeight() : this.widget.getHeight()) : (v = this.maxHeight.floatValue());
        if (v > 0.0f) {
            v += this.padTop + this.padBottom;
        }
        return v;
    }

    public float getPadTop() {
        return this.padTop;
    }

    public float getPadLeft() {
        return this.padLeft;
    }

    public float getPadBottom() {
        return this.padBottom;
    }

    public float getPadRight() {
        return this.padRight;
    }

    public float getFillX() {
        return this.fillX;
    }

    public float getFillY() {
        return this.fillY;
    }

    public int getAlign() {
        return this.align;
    }

    public void setRound(boolean round) {
        this.round = round;
    }

    public void setClip(boolean enabled) {
        this.clip = enabled;
        this.setTransform(enabled);
        this.invalidate();
    }

    public boolean getClip() {
        return this.clip;
    }

    @Override
    public Actor hit(float x, float y, boolean touchable) {
        if (this.clip) {
            if (touchable && this.getTouchable() == Touchable.disabled) {
                return null;
            }
            if (x < 0.0f || x >= this.getWidth() || y < 0.0f || y >= this.getHeight()) {
                return null;
            }
        }
        return super.hit(x, y, touchable);
    }
}

