/*
 * Decompiled with CFR 0.152.
 */
package walnoot.rhomboid.states;

import com.badlogic.gdx.Gdx;
import com.badlogic.gdx.graphics.Color;
import com.badlogic.gdx.graphics.OrthographicCamera;
import com.badlogic.gdx.graphics.g2d.Batch;
import com.badlogic.gdx.graphics.g2d.SpriteBatch;
import walnoot.libgdxutils.State;
import walnoot.rhomboid.Assets;
import walnoot.rhomboid.PrototypeLoader;
import walnoot.rhomboid.states.GameState;

public class MenuState
extends State {
    private OrthographicCamera camera = new OrthographicCamera();
    private SpriteBatch batch = new SpriteBatch();
    private int index;
    private PrototypeLoader loader;
    private GameState previous;

    public MenuState(PrototypeLoader loader) {
        this(loader, null);
    }

    public MenuState(PrototypeLoader loader, GameState previous) {
        this.loader = loader;
        this.previous = previous;
    }

    @Override
    public void render() {
        this.clearScreen(Color.BLACK);
        this.camera.update();
        this.batch.setProjectionMatrix(this.camera.combined);
        this.batch.begin();
        this.drawText(-2, "[GREEN]Turnstone");
        int i = 0;
        while (i < MenuItem.values().length) {
            MenuItem item = MenuItem.values()[i];
            String color = i == this.index ? "[WHITE]" : "[GRAY]";
            String text = item.text;
            if (item == MenuItem.PLAY && this.previous != null) {
                text = "Resume Game";
            }
            this.drawText(i, String.valueOf(color) + text);
            ++i;
        }
        this.batch.end();
        if (Gdx.input.isKeyJustPressed(20)) {
            ++this.index;
        }
        if (Gdx.input.isKeyJustPressed(19)) {
            --this.index;
        }
        int max = MenuItem.values().length;
        if (this.index < 0) {
            this.index += max;
        }
        if (this.index >= max) {
            this.index -= max;
        }
        if (Gdx.input.isKeyJustPressed(62)) {
            switch (MenuItem.values()[this.index]) {
                case PLAY: {
                    if (this.previous == null) {
                        this.manager.transitionTo((State)new GameState(this.loader, "l0"), 1.0f);
                        break;
                    }
                    this.manager.transitionTo((State)this.previous, 1.0f);
                    break;
                }
                case FULLSCREEN: {
                    if (Gdx.graphics.isFullscreen()) {
                        Gdx.graphics.setWindowedMode(1200, 675);
                        break;
                    }
                    Gdx.graphics.setFullscreenMode(Gdx.graphics.getDisplayMode());
                    break;
                }
                case EXIT: {
                    Gdx.app.exit();
                    break;
                }
            }
        }
    }

    private void drawText(int i, String text) {
        Assets.font.draw((Batch)this.batch, text, 0.0f, (float)(-i) * Assets.font.getLineHeight());
    }

    @Override
    public void update() {
        if (Gdx.input.isKeyJustPressed(131) && this.previous != null) {
            this.manager.transitionTo((State)this.previous, 0.3f);
        }
    }

    @Override
    public void resize(boolean creation, int width, int height) {
        this.camera.viewportHeight = 2.0f;
        this.camera.viewportWidth = 2.0f * (float)width / (float)height;
        this.camera.zoom = 8.0f;
    }

    private static enum MenuItem {
        PLAY("Play Game"),
        FULLSCREEN("Toggle Fullscreen"),
        EXIT("Exit");

        private String text;

        private MenuItem(String text) {
            this.text = text;
        }
    }
}

