/*
 * Decompiled with CFR 0.152.
 */
package walnoot.rhomboid.states;

import com.badlogic.gdx.Gdx;
import com.badlogic.gdx.InputAdapter;
import com.badlogic.gdx.graphics.Color;
import com.badlogic.gdx.graphics.g2d.Sprite;
import com.badlogic.gdx.math.MathUtils;
import com.badlogic.gdx.math.Vector2;
import com.badlogic.gdx.math.Vector3;
import com.badlogic.gdx.physics.box2d.FixtureDef;
import com.badlogic.gdx.physics.box2d.PolygonShape;
import com.badlogic.gdx.utils.Array;
import com.badlogic.gdx.utils.Json;
import com.badlogic.gdx.utils.JsonReader;
import com.badlogic.gdx.utils.JsonValue;
import java.io.File;
import java.io.IOException;
import java.io.PrintWriter;
import javax.swing.JFileChooser;
import javax.swing.JOptionPane;
import javax.swing.filechooser.FileNameExtensionFilter;
import walnoot.libgdxutils.State;
import walnoot.rhomboid.Entity;
import walnoot.rhomboid.GameWorld;
import walnoot.rhomboid.PrototypeLoader;
import walnoot.rhomboid.WorldRenderer;
import walnoot.rhomboid.components.FixturesComponent;
import walnoot.rhomboid.components.GoalComponent;
import walnoot.rhomboid.components.MovePlatformComponent;
import walnoot.rhomboid.components.PlayerComponent;
import walnoot.rhomboid.components.ShapePickupComponent;
import walnoot.rhomboid.components.SpritesComponent;
import walnoot.rhomboid.states.EndState;
import walnoot.rhomboid.states.MenuState;

public class GameState
extends State {
    private final GameWorld world;
    private WorldRenderer renderer;
    private EditorInput editor = new EditorInput();
    public static String path;
    private PrototypeLoader loader;
    private String level = "l0";

    public GameState(PrototypeLoader loader) {
        this.loader = loader;
        this.world = new GameWorld(loader);
        this.world.addEntity("player");
        this.world.addEntity("floor").getBody().setTransform(0.0f, -3.0f, 0.0f);
    }

    public GameState(PrototypeLoader loader, String level) {
        this(loader);
        this.level = level;
        this.loadLevel(level);
        path = level;
    }

    @Override
    public void show() {
        if (this.renderer == null) {
            this.renderer = new WorldRenderer(this.world, this.manager.getRenderContext());
        }
    }

    @Override
    public void hide() {
    }

    @Override
    public void update() {
        this.world.update();
        this.world.stream().map(e -> e.get(GoalComponent.class)).filter(g -> g != null).filter(g -> g.isTriggered()).findAny().ifPresent(g -> {
            if (g.nextLevel.equals("end")) {
                this.manager.transitionTo((State)new EndState(this.loader), 1.0f);
            } else {
                this.manager.transitionTo((State)new GameState(this.loader, g.nextLevel), 1.0f);
            }
        });
        this.world.stream().map(e -> e.get(PlayerComponent.class)).filter(g -> g != null).filter(g -> g.shouldRespawn()).findAny().ifPresent(p -> this.manager.transitionTo((State)new GameState(this.loader, this.level), 0.3f));
        if (Gdx.input.isKeyJustPressed(131)) {
            this.manager.transitionTo((State)new MenuState(this.loader, this), 0.3f);
        }
    }

    @Override
    public void render() {
        this.clearScreen(Color.BLACK);
        this.renderer.render();
    }

    @Override
    public void resize(boolean creation, int width, int height) {
        this.renderer.resize(width, height);
    }

    private void loadLevel(String path) {
        try {
            Json json = this.loader.getJson();
            JsonValue jsonValue = new JsonReader().parse(Gdx.files.internal(String.valueOf(path) + ".json"));
            JsonValue object = jsonValue.get((String)"objects").child;
            while (object != null) {
                JsonValue shapeJson = object.get("shape");
                Vector2[] vertices = new Vector2[shapeJson.size];
                int i = 0;
                JsonValue vector = shapeJson.child;
                while (vector != null) {
                    vertices[i++] = json.readValue(Vector2.class, vector);
                    vector = vector.next;
                }
                Entity e = this.world.addEntity("object");
                PolygonShape shape = new PolygonShape();
                shape.set(vertices);
                FixtureDef def = FixturesComponent.getDefaultFixture();
                def.shape = shape;
                if (object.has("goal")) {
                    e.addComponent(new GoalComponent(object.getString("goal")));
                    def.isSensor = true;
                }
                if (object.has("pos")) {
                    e.setPos(json.readValue("pos", Vector2.class, object));
                }
                if (object.has("movePlatform")) {
                    MovePlatformComponent move = json.readValue("movePlatform", MovePlatformComponent.class, object);
                    e.addComponent(move);
                    e.setPos(new Vector2(move.startX, move.startY));
                }
                if (object.has("sprites")) {
                    SpritesComponent sComp = new SpritesComponent();
                    for (JsonValue sprite : object.get("sprites")) {
                        SpritesComponent.ComponentSprite cs = json.readValue(SpritesComponent.ComponentSprite.class, sprite);
                        sComp.sprites.add(cs);
                    }
                    e.addComponent(sComp);
                }
                e.getBody().createFixture(def);
                object = object.next;
            }
            for (JsonValue pickup : jsonValue.get("pickups")) {
                String shape;
                Entity e = this.world.getLoader().createProto("pickup");
                while (this.world.getShape(shape = pickup.getString("shape")) == null) {
                }
                e.get(ShapePickupComponent.class).shape = shape;
                this.world.addEntity(e);
                e.setPos(json.readValue(Vector2.class, pickup.get("pos")));
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private class EditorInput
    extends InputAdapter {
        private Entity selection;
        private Vector3 pos = new Vector3();
        private Array<Vector2> positions = new Array();

        private EditorInput() {
        }

        @Override
        public boolean touchDown(int screenX, int screenY, int pointer, int button) {
            GameState.this.renderer.getCamera().unproject(this.pos.set(screenX, screenY, 0.0f));
            Vector2 point = new Vector2(this.pos.x, this.pos.y);
            Vector2 roundPoint = new Vector2(MathUtils.round(this.pos.x), MathUtils.round(this.pos.y));
            if (button == 0) {
                if (Gdx.input.isKeyPressed(129)) {
                    System.out.println("adding point");
                    this.positions.add(roundPoint);
                } else {
                    this.selection = null;
                    GameState.this.world.queryPoint(point, e -> {
                        System.out.println("Selected");
                        this.selection = e;
                        this.positions.clear();
                    });
                }
            } else if (button == 1) {
                String shape;
                Entity pickup = GameState.this.world.getLoader().createProto("pickup");
                do {
                    shape = JOptionPane.showInputDialog("shape");
                } while (GameState.this.world.getShape(shape) == null);
                pickup.get(ShapePickupComponent.class).shape = shape;
                GameState.this.world.addEntity(pickup);
                pickup.setPos(roundPoint);
            }
            return true;
        }

        @Override
        public boolean keyDown(int keycode) {
            boolean handled = true;
            switch (keycode) {
                case 66: {
                    if (this.positions.size <= 2) break;
                    Entity object = GameState.this.world.addEntity("object");
                    Vector2 origin = new Vector2();
                    for (Vector2 pos : this.positions) {
                        origin.x += pos.x;
                        origin.y += pos.y;
                    }
                    origin.scl(1.0f / (float)this.positions.size);
                    PolygonShape shape = new PolygonShape();
                    float[] vertices = new float[2 * this.positions.size];
                    int i = 0;
                    while (i < this.positions.size) {
                        vertices[2 * i] = this.positions.get((int)i).x - origin.x;
                        vertices[2 * i + 1] = this.positions.get((int)i).y - origin.y;
                        ++i;
                    }
                    shape.set(vertices, 0, vertices.length);
                    object.getBody().createFixture(shape, 1.0f);
                    object.setPos(origin);
                    this.positions.clear();
                    break;
                }
                case 67: {
                    this.positions.clear();
                    if (this.selection == null) break;
                    GameState.this.world.removeEntity(this.selection);
                    break;
                }
                case 35: {
                    if (this.selection == null || this.selection.has(GoalComponent.class)) break;
                    this.selection.addComponent(new GoalComponent(JOptionPane.showInputDialog("next level:")));
                    break;
                }
                case 47: {
                    if (!Gdx.input.isKeyPressed(129)) break;
                    try {
                        if (path == null || Gdx.input.isKeyPressed(59)) {
                            path = JOptionPane.showInputDialog("Save as..");
                        }
                        Json json = new Json();
                        File file = new File(String.valueOf(path) + ".json");
                        file.createNewFile();
                        PrintWriter writer = new PrintWriter(file);
                        json.setWriter(writer);
                        json.writeObjectStart();
                        json.writeArrayStart("objects");
                        Vector2 vertex = new Vector2();
                        GameState.this.world.stream().filter(e -> e.name.equals("object")).forEach(e -> {
                            json.writeObjectStart();
                            Array<Vector2> shapeArray = new Array<Vector2>();
                            PolygonShape shape = (PolygonShape)e.getBody().getFixtureList().get(0).getShape();
                            int i = 0;
                            while (i < shape.getVertexCount()) {
                                shape.getVertex(i, vertex);
                                shapeArray.add(new Vector2(vertex));
                                ++i;
                            }
                            json.writeValue("shape", shapeArray);
                            json.writeValue("pos", e.getBody().getPosition());
                            if (e.has(GoalComponent.class)) {
                                json.writeValue("goal", e.get(GoalComponent.class).nextLevel);
                            }
                            if (e.has(MovePlatformComponent.class)) {
                                json.writeObjectStart("movePlatform");
                                MovePlatformComponent component = e.get(MovePlatformComponent.class);
                                json.writeField(component, "moveX");
                                json.writeField(component, "moveY");
                                json.writeField(component, "startX");
                                json.writeField(component, "startY");
                                json.writeObjectEnd();
                            }
                            if (e.has(SpritesComponent.class)) {
                                json.writeArrayStart("sprites");
                                for (SpritesComponent.ComponentSprite cs : e.get(SpritesComponent.class).sprites) {
                                    json.writeObjectStart();
                                    json.writeField(cs, "name");
                                    json.writeField(cs, "index");
                                    json.writeField(cs, "width");
                                    json.writeField(cs, "height");
                                    json.writeField(cs, "xOffset");
                                    json.writeField(cs, "yOffset");
                                    json.writeObjectEnd();
                                }
                                json.writeArrayEnd();
                            }
                            json.writeObjectEnd();
                        });
                        json.writeArrayEnd();
                        json.writeArrayStart("pickups");
                        GameState.this.world.stream().filter(e -> e.has(ShapePickupComponent.class)).forEach(e -> {
                            json.writeObjectStart();
                            json.writeValue("pos", e.getBody().getPosition());
                            json.writeValue("shape", e.get(ShapePickupComponent.class).shape);
                            json.writeObjectEnd();
                        });
                        json.writeArrayEnd();
                        json.writeObjectEnd();
                        writer.close();
                    }
                    catch (IOException e2) {
                        e2.printStackTrace();
                    }
                    break;
                }
                case 43: {
                    if (!Gdx.input.isKeyPressed(129)) break;
                    path = JOptionPane.showInputDialog("Open..", (Object)path);
                    GameState.this.manager.setState(new GameState(GameState.this.loader, path));
                    break;
                }
                case 42: {
                    if (this.selection == null) break;
                    JFileChooser chooser = new JFileChooser(new File("../core/assets"));
                    chooser.setFileFilter(new FileNameExtensionFilter(null, "png"));
                    if (chooser.showOpenDialog(null) != 0) break;
                    String name = chooser.getSelectedFile().getName().replaceAll("\\..*", "");
                    Sprite sprite = GameState.this.loader.getAtlas().createSprite(name);
                    SpritesComponent.ComponentSprite cs = new SpritesComponent.ComponentSprite();
                    cs.sprite = sprite;
                    cs.width = sprite.getWidth() / 64.0f;
                    cs.height = sprite.getHeight() / 64.0f;
                    cs.name = name;
                    if (!this.selection.has(SpritesComponent.class)) {
                        this.selection.addComponent(new SpritesComponent());
                    }
                    this.selection.get(SpritesComponent.class).sprites.add(cs);
                    break;
                }
                case 41: {
                    if (this.selection == null) break;
                    if (!this.selection.has(MovePlatformComponent.class)) {
                        this.selection.addComponent(new MovePlatformComponent());
                    }
                    float x = Float.parseFloat(JOptionPane.showInputDialog("x speed", (Object)0));
                    float y = Float.parseFloat(JOptionPane.showInputDialog("y speed", (Object)0));
                    MovePlatformComponent move = this.selection.get(MovePlatformComponent.class);
                    move.moveX = x;
                    move.moveY = y;
                    move.startX = this.selection.getX();
                    move.startY = this.selection.getY();
                    break;
                }
                case 146: 
                case 148: 
                case 150: 
                case 152: {
                    int[] keys = new int[]{148, 150, 152, 146};
                    int[] nArray = new int[4];
                    nArray[0] = -1;
                    nArray[1] = 1;
                    int[] xs = nArray;
                    int[] nArray2 = new int[4];
                    nArray2[2] = 1;
                    nArray2[3] = -1;
                    int[] ys = nArray2;
                    int xtemp = 0;
                    int ytemp = 0;
                    int i = 0;
                    while (i < 4) {
                        if (keycode == keys[i]) {
                            xtemp = xs[i];
                            ytemp = ys[i];
                        }
                        ++i;
                    }
                    int x = xtemp;
                    int y = ytemp;
                    if (this.selection == null || !this.selection.has(SpritesComponent.class)) break;
                    SpritesComponent.ComponentSprite sprite = this.selection.get(SpritesComponent.class).sprites.peek();
                    if (Gdx.input.isKeyPressed(129)) {
                        sprite.width += (float)x;
                        sprite.height += (float)y;
                        break;
                    }
                    sprite.xOffset += (float)x * 0.5f;
                    sprite.yOffset += (float)y * 0.5f;
                    break;
                }
                case 149: {
                    if (this.selection == null || !this.selection.has(SpritesComponent.class)) break;
                    Array<SpritesComponent.ComponentSprite> sprites = this.selection.get(SpritesComponent.class).sprites;
                    SpritesComponent.ComponentSprite sprite = sprites.removeIndex(0);
                    sprites.add(sprite);
                    break;
                }
                case 144: {
                    if (this.selection == null || !this.selection.has(SpritesComponent.class)) break;
                    this.selection.get(SpritesComponent.class).sprites.pop();
                    break;
                }
                default: {
                    handled = false;
                }
            }
            return handled;
        }
    }
}

