/*
 * Decompiled with CFR 0.152.
 */
package walnoot.rhomboid.states;

import com.badlogic.gdx.Gdx;
import com.badlogic.gdx.graphics.Color;
import com.badlogic.gdx.graphics.OrthographicCamera;
import com.badlogic.gdx.graphics.g2d.Batch;
import com.badlogic.gdx.graphics.g2d.SpriteBatch;
import walnoot.libgdxutils.State;
import walnoot.rhomboid.Assets;
import walnoot.rhomboid.PrototypeLoader;
import walnoot.rhomboid.states.MenuState;

public class EndState
extends State {
    private OrthographicCamera camera = new OrthographicCamera();
    private SpriteBatch batch = new SpriteBatch();
    private PrototypeLoader loader;

    public EndState(PrototypeLoader loader) {
        this.loader = loader;
    }

    @Override
    public void render() {
        this.clearScreen(Color.BLACK);
        this.camera.update();
        this.batch.setProjectionMatrix(this.camera.combined);
        this.batch.begin();
        this.drawText(0, "The end");
        this.batch.end();
        if (Gdx.input.isKeyJustPressed(62)) {
            this.manager.transitionTo((State)new MenuState(this.loader), 1.0f);
        }
    }

    private void drawText(int i, String text) {
        Assets.font.draw((Batch)this.batch, text, 0.0f, (float)(-i) * Assets.font.getLineHeight());
    }

    @Override
    public void resize(boolean creation, int width, int height) {
        this.camera.viewportHeight = 2.0f;
        this.camera.viewportWidth = 2.0f * (float)width / (float)height;
        this.camera.zoom = 8.0f;
    }
}

