/*
 * Decompiled with CFR 0.152.
 */
package walnoot.rhomboid.components;

import com.badlogic.gdx.math.MathUtils;
import com.badlogic.gdx.math.Vector2;
import com.badlogic.gdx.physics.box2d.Contact;
import com.badlogic.gdx.physics.box2d.FixtureDef;
import walnoot.rhomboid.Component;
import walnoot.rhomboid.Entity;
import walnoot.rhomboid.PlayerShape;
import walnoot.rhomboid.components.PlayerComponent;
import walnoot.rhomboid.components.SpritesComponent;

public class ShapePickupComponent
extends Component {
    public String shape;
    private PlayerComponent player;

    @Override
    public void init() {
        PlayerShape playerShape = this.world.getShape(this.shape);
        FixtureDef def = new FixtureDef();
        def.shape = playerShape.shape;
        def.isSensor = true;
        this.body.createFixture(def);
        this.body.setAngularVelocity(1.0f);
        this.e.get(SpritesComponent.class).sprites.add(playerShape.sprite);
    }

    @Override
    public void update() {
        if (this.player != null) {
            PlayerShape newShape = this.world.getShape(this.shape);
            if (newShape != this.player.getShape()) {
                int i = 0;
                while (i < 30) {
                    Entity dust = this.world.addEntity("change_particle");
                    dust.setPos(this.player.body.getPosition());
                    dust.getBody().setLinearVelocity(new Vector2(0.0f, 1.0f).rotate(MathUtils.random(360.0f)).scl(MathUtils.random(4.0f)));
                    ++i;
                }
            }
            this.player.setShape(newShape);
            this.player = null;
        }
    }

    @Override
    public void beginContact(Contact contact, Entity other) {
        PlayerComponent playerComponent = other.get(PlayerComponent.class);
        if (playerComponent != null) {
            this.player = playerComponent;
        }
    }
}

