/*
 * Decompiled with CFR 0.152.
 */
package walnoot.rhomboid.components;

import com.badlogic.gdx.Gdx;
import com.badlogic.gdx.math.MathUtils;
import com.badlogic.gdx.math.Vector2;
import com.badlogic.gdx.physics.box2d.Contact;
import com.badlogic.gdx.physics.box2d.Fixture;
import com.badlogic.gdx.physics.box2d.FixtureDef;
import com.badlogic.gdx.utils.Array;
import walnoot.rhomboid.Component;
import walnoot.rhomboid.Entity;
import walnoot.rhomboid.PlayerShape;
import walnoot.rhomboid.components.SpritesComponent;

public class PlayerComponent
extends Component {
    private static final Vector2 REF = new Vector2(0.0f, -1.0f);
    private static final float TORQUE_MULTIPLIER = 200.0f;
    private Array<PlayerShape> shapes;
    private Array<Entity> contacts = new Array();
    private Fixture current;
    private PlayerShape shape;
    private int index;
    private int timer;
    private int lastContactTime;
    private boolean canJump;
    private boolean shouldRespawn;
    private Vector2 dustPoint = null;

    @Override
    public void init() {
        this.shapes = this.world.getShapes();
        this.setShape(this.shapes.get(0));
    }

    @Override
    public void update() {
        int delta;
        ++this.timer;
        if (this.contacts.size > 0) {
            this.lastContactTime = this.timer;
            this.canJump = true;
        }
        if ((float)(delta = this.timer - this.lastContactTime) < 15.0f) {
            float dir = 0.0f;
            if (Gdx.input.isKeyPressed(22)) {
                dir = 1.0f;
            }
            if (Gdx.input.isKeyPressed(21)) {
                dir = -1.0f;
            }
            this.body.applyTorque(dir * -200.0f * this.shape.torque, true);
            this.body.applyForceToCenter(dir * 20.0f * this.shape.boost, 0.0f, true);
            if (Gdx.input.isKeyPressed(62) && this.canJump && this.shape.jump != 0.0f) {
                this.canJump = false;
                float impulseX = dir * 6.0f * this.body.getMass() * this.shape.jump;
                float impulseY = 12.0f * this.body.getMass() * this.shape.jump;
                this.body.setLinearVelocity(impulseX, impulseY);
            }
        }
        if (this.e.getY() < -80.0f) {
            this.respawn();
        }
        float angVel = this.body.getAngularVelocity();
        if (this.dustPoint != null && Math.abs(this.body.getAngularVelocity()) > 3.0f) {
            int i = 0;
            while (i < 3) {
                Entity dust = this.world.addEntity("dust");
                dust.setPos(this.dustPoint);
                dust.getBody().setLinearVelocity(0.5f * this.body.getAngularVelocity() * MathUtils.random(0.25f, 1.0f), MathUtils.random(0.5f, 1.5f));
                ++i;
            }
            this.dustPoint = null;
        }
        if (Math.abs(angVel) > 5.0f * this.shape.speed) {
            this.body.setAngularVelocity(5.0f * this.shape.speed * Math.signum(angVel));
        }
    }

    public void respawn() {
        this.shouldRespawn = true;
    }

    public void setShape(PlayerShape shape) {
        if (shape != this.shape) {
            FixtureDef def = new FixtureDef();
            def.shape = shape.shape;
            def.friction = 1.0f;
            def.density = 1.0f;
            if (this.current != null) {
                this.body.destroyFixture(this.current);
            }
            this.current = this.body.createFixture(def);
            this.shape = shape;
            Array<SpritesComponent.ComponentSprite> sprites = this.e.get(SpritesComponent.class).sprites;
            sprites.clear();
            if (shape.sprite != null) {
                sprites.add(shape.sprite.getCopy(this.world.getLoader().getAtlas()));
            }
        }
    }

    public boolean shouldRespawn() {
        return this.shouldRespawn;
    }

    public PlayerShape getShape() {
        return this.shape;
    }

    @Override
    public void beginContact(Contact contact, Entity other) {
        int i = 0;
        while (i < contact.getWorldManifold().getNumberOfContactPoints()) {
            Vector2 point = contact.getWorldManifold().getPoints()[i];
            if (point.y < this.e.getY()) {
                this.contacts.add(other);
                this.dustPoint = new Vector2(point);
                return;
            }
            ++i;
        }
    }

    @Override
    public void endContact(Contact contact, Entity other) {
        this.contacts.removeValue(other, true);
    }
}

