/*
 * Decompiled with CFR 0.152.
 */
package walnoot.rhomboid.components;

import com.badlogic.gdx.physics.box2d.Body;
import com.badlogic.gdx.physics.box2d.BodyDef;
import walnoot.rhomboid.Component;
import walnoot.rhomboid.GameWorld;

public class MovePlatformComponent
extends Component {
    public float speed = 4.0f;
    public float moveX;
    public float moveY;
    public float startX;
    public float startY;
    private int timer;

    @Override
    public void setWorld(GameWorld world, Body body) {
        super.setWorld(world, body);
        if (body != null) {
            body.setType(BodyDef.BodyType.KinematicBody);
        }
    }

    @Override
    public void update() {
        ++this.timer;
        int idleTicks = 60;
        int moveTicks = (int)(60.0f * (this.moveX + this.moveY));
        if (this.timer >= 2 * (idleTicks + moveTicks)) {
            this.timer = 0;
        }
        if (this.timer < idleTicks) {
            this.body.setLinearVelocity(0.0f, 0.0f);
        } else if (this.timer < idleTicks + moveTicks) {
            this.body.setLinearVelocity(Math.signum(this.moveX) * this.speed, Math.signum(this.moveY) * this.speed);
        } else if (this.timer < 2 * idleTicks + moveTicks) {
            this.body.setLinearVelocity(0.0f, 0.0f);
        } else {
            this.body.setLinearVelocity(-Math.signum(this.moveX) * this.speed, -Math.signum(this.moveY) * this.speed);
        }
    }
}

