/*
 * Decompiled with CFR 0.152.
 */
package walnoot.rhomboid;

import com.badlogic.gdx.Gdx;
import com.badlogic.gdx.graphics.Color;
import com.badlogic.gdx.graphics.OrthographicCamera;
import com.badlogic.gdx.graphics.g2d.Sprite;
import com.badlogic.gdx.graphics.g2d.SpriteBatch;
import com.badlogic.gdx.graphics.glutils.ShapeRenderer;
import com.badlogic.gdx.math.MathUtils;
import com.badlogic.gdx.physics.box2d.Box2DDebugRenderer;
import com.badlogic.gdx.utils.Array;
import walnoot.libgdxutils.RenderContext;
import walnoot.rhomboid.Entity;
import walnoot.rhomboid.GameWorld;
import walnoot.rhomboid.components.PlayerComponent;
import walnoot.rhomboid.components.SpritesComponent;

public class WorldRenderer {
    private static final float SECTOR_SIZE = 40.0f;
    private final GameWorld world;
    private float[] randoms = new float[73];
    private Box2DDebugRenderer debug = new Box2DDebugRenderer();
    private ShapeRenderer shapeRenderer = new ShapeRenderer();
    private SpriteBatch batch = new SpriteBatch();
    private OrthographicCamera camera = new OrthographicCamera();
    private OrthographicCamera uiCamera = new OrthographicCamera();
    private Array<SpritesComponent.ComponentSprite> componentSprites = new Array();
    private Entity player;
    private RenderContext renderContext;

    public WorldRenderer(GameWorld world, RenderContext renderContext) {
        this.world = world;
        this.renderContext = renderContext;
        int i = 0;
        while (i < this.randoms.length) {
            this.randoms[i] = MathUtils.random();
            ++i;
        }
    }

    public void render() {
        Color color = Color.BLACK;
        Gdx.gl20.glClearColor(color.r, color.g, color.b, color.a);
        Gdx.gl20.glClear(16384);
        this.player = null;
        this.world.forAllEntities(e -> {
            if (e.has(PlayerComponent.class)) {
                this.camera.position.x += (e.getX() - this.camera.position.x) * 0.1f;
                this.camera.position.y += (e.getY() - this.camera.position.y) * 0.1f;
                this.player = e;
            }
        });
        this.camera.update();
        this.batch.setProjectionMatrix(this.camera.combined);
        this.batch.begin();
        this.componentSprites.clear();
        this.world.forAllEntities(e -> {
            if (e.has(SpritesComponent.class)) {
                for (SpritesComponent.ComponentSprite cs : e.get(SpritesComponent.class).sprites) {
                    Sprite s = cs.sprite;
                    s.setSize(cs.width, cs.height);
                    s.setOrigin(s.getWidth() / 2.0f, s.getHeight() / 2.0f);
                    s.setCenter(e.getX() + cs.xOffset, e.getY() + cs.yOffset);
                    s.setRotation(e.getBody().getAngle() * 57.295776f);
                    s.setColor(cs.color);
                    this.componentSprites.add(cs);
                }
            }
        });
        this.componentSprites.sort((s1, s2) -> Integer.compare(s1.index, s2.index));
        for (SpritesComponent.ComponentSprite s : this.componentSprites) {
            s.sprite.draw(this.batch);
        }
        this.batch.end();
        this.uiCamera.update();
        this.batch.setProjectionMatrix(this.uiCamera.combined);
        this.batch.begin();
        this.batch.end();
    }

    public void resize(int width, int height) {
        this.camera.viewportHeight = 2.0f;
        this.camera.viewportWidth = 2.0f * (float)width / (float)height;
        this.camera.zoom = 8.0f;
        this.uiCamera.viewportHeight = 2.0f;
        this.uiCamera.viewportWidth = 2.0f * (float)width / (float)height;
        this.uiCamera.zoom = 12.0f;
    }

    public OrthographicCamera getCamera() {
        return this.camera;
    }
}

