/*
 * Decompiled with CFR 0.152.
 */
package walnoot.rhomboid;

import com.badlogic.gdx.Gdx;
import com.badlogic.gdx.InputMultiplexer;
import com.badlogic.gdx.graphics.Pixmap;
import com.badlogic.gdx.graphics.Texture;
import com.badlogic.gdx.graphics.g2d.PixmapPacker;
import com.badlogic.gdx.graphics.g2d.TextureAtlas;
import com.badlogic.gdx.graphics.g2d.freetype.FreeTypeFontGenerator;
import java.util.Scanner;
import walnoot.libgdxutils.State;
import walnoot.libgdxutils.StateApplication;
import walnoot.rhomboid.Assets;
import walnoot.rhomboid.PrototypeLoader;
import walnoot.rhomboid.states.MenuState;

public class RhomboidGame
extends StateApplication {
    public static final boolean DEBUG = false;
    public static final InputMultiplexer inputs = new InputMultiplexer();
    private PrototypeLoader loader;

    public RhomboidGame() {
        super(60.0f, false);
    }

    @Override
    protected void update() {
        super.update();
        if (Gdx.input.isKeyJustPressed(248)) {
            this.setState(this.getFirstState());
        }
    }

    @Override
    protected void init() {
        PixmapPacker packer = new PixmapPacker(1024, 1024, Pixmap.Format.RGBA8888, 2, false);
        Scanner scanner = new Scanner(Gdx.files.internal("filelist").read());
        while (scanner.hasNextLine()) {
            String file = scanner.nextLine();
            packer.pack(file.replaceAll("\\..*", ""), new Pixmap(Gdx.files.internal(file)));
        }
        scanner.close();
        TextureAtlas atlas = packer.generateTextureAtlas(Texture.TextureFilter.MipMapLinearLinear, Texture.TextureFilter.Linear, true);
        this.loader = new PrototypeLoader(atlas);
        Gdx.input.setInputProcessor(inputs);
        FreeTypeFontGenerator generator = new FreeTypeFontGenerator(Gdx.files.internal("KaushanScript-Regular.ttf"));
        FreeTypeFontGenerator.FreeTypeFontParameter parameter = new FreeTypeFontGenerator.FreeTypeFontParameter();
        parameter.size = 48;
        parameter.packer = packer;
        parameter.magFilter = Texture.TextureFilter.Linear;
        parameter.minFilter = Texture.TextureFilter.MipMapLinearLinear;
        parameter.genMipMaps = true;
        Assets.font = generator.generateFont(parameter);
        Assets.font.setUseIntegerPositions(false);
        Assets.font.getData().setScale(1.0f / (float)parameter.size);
        Assets.font.getData().markupEnabled = true;
    }

    @Override
    protected State getFirstState() {
        return new MenuState(this.loader);
    }

    @Override
    protected int getExitKey() {
        return 68;
    }
}

