/*
 * Decompiled with CFR 0.152.
 */
package walnoot.rhomboid;

import com.badlogic.gdx.Gdx;
import com.badlogic.gdx.graphics.g2d.TextureAtlas;
import com.badlogic.gdx.math.Vector2;
import com.badlogic.gdx.physics.box2d.BodyDef;
import com.badlogic.gdx.physics.box2d.CircleShape;
import com.badlogic.gdx.physics.box2d.FixtureDef;
import com.badlogic.gdx.physics.box2d.PolygonShape;
import com.badlogic.gdx.physics.box2d.Shape;
import com.badlogic.gdx.utils.Json;
import com.badlogic.gdx.utils.JsonReader;
import com.badlogic.gdx.utils.JsonValue;
import com.badlogic.gdx.utils.ObjectMap;
import walnoot.rhomboid.Component;
import walnoot.rhomboid.Entity;
import walnoot.rhomboid.components.BodyDefComponent;
import walnoot.rhomboid.components.FadeComponent;
import walnoot.rhomboid.components.FixturesComponent;
import walnoot.rhomboid.components.PlayerComponent;
import walnoot.rhomboid.components.ShapePickupComponent;
import walnoot.rhomboid.components.SpritesComponent;

public class PrototypeLoader {
    private ObjectMap<String, JsonValue> prototypes = new ObjectMap();
    private TextureAtlas atlas;
    private Json json = new Json();
    private JsonValue jsonValue;

    public PrototypeLoader(final TextureAtlas atlas) {
        this.atlas = atlas;
        this.jsonValue = new JsonReader().parse(Gdx.files.internal("proto.json"));
        JsonValue proto = this.jsonValue.get((String)"protos").child;
        while (proto != null) {
            this.prototypes.put(proto.name, proto);
            proto = proto.next;
        }
        this.json.setSerializer(Shape.class, new Json.ReadOnlySerializer<Shape>(){

            @Override
            public Shape read(Json json, JsonValue jsonData, Class type) {
                if (jsonData.getString(0).equals("box")) {
                    PolygonShape box = new PolygonShape();
                    Vector2 pos = new Vector2();
                    if (jsonData.get(4) != null) {
                        pos.set(jsonData.getFloat(3), jsonData.getFloat(4));
                    }
                    box.setAsBox(jsonData.getFloat(1), jsonData.getFloat(2), pos, 0.0f);
                    return box;
                }
                if (jsonData.getString(0).equals("circle")) {
                    CircleShape circle = new CircleShape();
                    circle.setRadius(jsonData.getFloat(1));
                    return circle;
                }
                return null;
            }
        });
        this.json.setSerializer(SpritesComponent.ComponentSprite.class, new Json.ReadOnlySerializer<SpritesComponent.ComponentSprite>(){

            @Override
            public SpritesComponent.ComponentSprite read(Json json, JsonValue jsonData, Class type) {
                SpritesComponent.ComponentSprite sprite = new SpritesComponent.ComponentSprite();
                json.readFields(sprite, jsonData);
                sprite.sprite = atlas.createSprite(sprite.name);
                return sprite;
            }

            @Override
            public void write(Json json, SpritesComponent.ComponentSprite object, Class knownType) {
                json.writeValue(object, knownType);
            }
        });
    }

    public Entity createProto(String name) {
        Entity entity = new Entity();
        JsonValue component = this.prototypes.get((String)name).child;
        ObjectMap<String, Class<FadeComponent>> defaultComponents = new ObjectMap<String, Class<FadeComponent>>();
        defaultComponents.put("player", PlayerComponent.class);
        defaultComponents.put("pickup", ShapePickupComponent.class);
        defaultComponents.put("fade", FadeComponent.class);
        while (component != null) {
            switch (component.name) {
                case "bodyDef": {
                    BodyDef def = BodyDefComponent.getDefaultDef();
                    this.json.readFields(def, component);
                    entity.addComponent(new BodyDefComponent(def));
                    break;
                }
                case "fixtures": {
                    FixturesComponent fixtures = new FixturesComponent();
                    JsonValue fixture = component.child;
                    while (fixture != null) {
                        FixtureDef fdef = FixturesComponent.getDefaultFixture();
                        this.json.readFields(fdef, fixture);
                        fixtures.fixtures.add(fdef);
                        fixture = fixture.next;
                    }
                    entity.addComponent(fixtures);
                    break;
                }
                case "sprites": {
                    SpritesComponent spritesComponent = new SpritesComponent();
                    JsonValue sprite = component.child;
                    while (sprite != null) {
                        SpritesComponent.ComponentSprite cs = this.json.readValue(SpritesComponent.ComponentSprite.class, sprite);
                        spritesComponent.sprites.add(cs);
                        sprite = sprite.next;
                    }
                    entity.addComponent(spritesComponent);
                    break;
                }
                default: {
                    if (defaultComponents.containsKey(component.name)) {
                        Component value = (Component)this.json.readValue((Class)defaultComponents.get(component.name), component);
                        entity.addComponent(value);
                        break;
                    }
                    System.out.println("Unknown component type: " + component.name);
                }
            }
            component = component.next;
        }
        return entity;
    }

    public TextureAtlas getAtlas() {
        return this.atlas;
    }

    public JsonValue getJsonValue() {
        return this.jsonValue;
    }

    public Json getJson() {
        return this.json;
    }
}

