/*
 * Decompiled with CFR 0.152.
 */
package walnoot.rhomboid;

import com.badlogic.gdx.math.Vector2;
import com.badlogic.gdx.physics.box2d.Body;
import com.badlogic.gdx.physics.box2d.BodyDef;
import com.badlogic.gdx.physics.box2d.Contact;
import com.badlogic.gdx.physics.box2d.ContactImpulse;
import com.badlogic.gdx.physics.box2d.ContactListener;
import com.badlogic.gdx.physics.box2d.Fixture;
import com.badlogic.gdx.physics.box2d.FixtureDef;
import com.badlogic.gdx.physics.box2d.Manifold;
import com.badlogic.gdx.physics.box2d.QueryCallback;
import com.badlogic.gdx.physics.box2d.World;
import com.badlogic.gdx.utils.Array;
import com.badlogic.gdx.utils.JsonValue;
import java.util.ArrayList;
import java.util.function.Consumer;
import java.util.stream.Stream;
import walnoot.rhomboid.Entity;
import walnoot.rhomboid.PlayerShape;
import walnoot.rhomboid.PrototypeLoader;
import walnoot.rhomboid.components.BodyDefComponent;
import walnoot.rhomboid.components.FixturesComponent;

public class GameWorld
implements ContactListener {
    private final BodyDef defaultDef = BodyDefComponent.getDefaultDef();
    private World world = new World(new Vector2(0.0f, -20.0f), true);
    private Array<Body> tmpBodies = new Array();
    private Array<Entity> removedEntities = new Array();
    private PrototypeLoader loader;
    private Array<PlayerShape> shapes = new Array();
    private RadiusSearcher searcher = new RadiusSearcher();

    public GameWorld(PrototypeLoader loader) {
        this.loader = loader;
        this.world.setContactListener(this);
        JsonValue shape = loader.getJsonValue().get((String)"shapes").child;
        while (shape != null) {
            this.shapes.add(loader.getJson().readValue(PlayerShape.class, shape));
            shape = shape.next;
        }
    }

    public void update() {
        this.world.step(0.016666668f, 8, 3);
        this.forAllEntities(e -> e.update());
        for (Entity e2 : this.removedEntities) {
            e2.onRemove();
            if (e2.getBody() != null) {
                this.world.destroyBody(e2.getBody());
            }
            e2.setWorld(null, null);
        }
        this.removedEntities.size = 0;
    }

    public void forAllEntities(Consumer<Entity> c) {
        this.world.getBodies(this.tmpBodies);
        int i = 0;
        while (i < this.tmpBodies.size) {
            c.accept((Entity)this.tmpBodies.get(i).getUserData());
            ++i;
        }
    }

    public Stream<Entity> stream() {
        ArrayList entities = new ArrayList();
        this.forAllEntities(e -> {
            boolean bl = entities.add(e);
        });
        return entities.stream();
    }

    public void queryRadius(Vector2 pos, float radius, Consumer<Entity> c) {
        this.searcher.startSearch(QueryType.IN_RADIUS, pos, radius, c);
        this.world.QueryAABB(this.searcher, pos.x - radius, pos.y - radius, pos.x + radius, pos.y + radius);
        this.searcher.endSearch();
    }

    public void queryPoint(Vector2 pos, Consumer<Entity> c) {
        this.searcher.startSearch(QueryType.OVERLAP_AABB, pos, 0.0f, c);
        this.world.QueryAABB(this.searcher, pos.x, pos.y, pos.x, pos.y);
        this.searcher.endSearch();
    }

    public Entity addEntity(Entity e) {
        BodyDefComponent defComponent = e.get(BodyDefComponent.class);
        Body body = this.world.createBody(defComponent == null ? this.defaultDef : defComponent.def);
        body.setUserData(e);
        if (e.has(FixturesComponent.class)) {
            for (FixtureDef def : e.get(FixturesComponent.class).fixtures) {
                body.createFixture(def);
            }
        }
        e.setWorld(this, body);
        e.forAllComponents(c -> c.init());
        return e;
    }

    public Entity addEntity(String proto) {
        Entity entity = this.addEntity(this.loader.createProto(proto));
        entity.name = proto;
        return entity;
    }

    public void removeEntity(Entity e) {
        this.removedEntities.add(e);
    }

    @Override
    public void beginContact(Contact contact) {
        Entity a = (Entity)contact.getFixtureA().getBody().getUserData();
        Entity b = (Entity)contact.getFixtureB().getBody().getUserData();
        a.beginContact(contact, b);
        b.beginContact(contact, a);
    }

    @Override
    public void endContact(Contact contact) {
        Entity a = (Entity)contact.getFixtureA().getBody().getUserData();
        Entity b = (Entity)contact.getFixtureB().getBody().getUserData();
        a.endContact(contact, b);
        b.endContact(contact, a);
    }

    @Override
    public void preSolve(Contact contact, Manifold oldManifold) {
    }

    @Override
    public void postSolve(Contact contact, ContactImpulse impulse) {
    }

    public World getBox2d() {
        return this.world;
    }

    public PrototypeLoader getLoader() {
        return this.loader;
    }

    public Array<PlayerShape> getShapes() {
        return this.shapes;
    }

    public PlayerShape getShape(String name) {
        for (PlayerShape shape : this.shapes) {
            if (!shape.name.equals(name)) continue;
            return shape;
        }
        return null;
    }

    public static enum QueryType {
        IN_RADIUS,
        OVERLAP_AABB;

    }

    private class RadiusSearcher
    implements QueryCallback {
        private QueryType type;
        private Vector2 pos = null;
        private float radius;
        private Consumer<Entity> c;

        private RadiusSearcher() {
        }

        private void startSearch(QueryType type, Vector2 pos, float radius, Consumer<Entity> c) {
            if (this.pos != null) {
                throw new IllegalStateException("Already searching radius!");
            }
            this.type = type;
            this.pos = pos;
            this.radius = radius;
            this.c = c;
        }

        private void endSearch() {
            this.pos = null;
            this.radius = 0.0f;
            this.c = null;
        }

        @Override
        public boolean reportFixture(Fixture fixture) {
            if (this.type == QueryType.OVERLAP_AABB || fixture.getBody().getPosition().dst2(this.pos) < this.radius * this.radius) {
                this.c.accept((Entity)fixture.getBody().getUserData());
            }
            return true;
        }
    }
}

