/*
 * Decompiled with CFR 0.152.
 */
package walnoot.rhomboid;

import com.badlogic.gdx.math.Vector2;
import com.badlogic.gdx.physics.box2d.Body;
import com.badlogic.gdx.physics.box2d.Contact;
import com.badlogic.gdx.utils.Array;
import com.badlogic.gdx.utils.IntMap;
import java.util.function.Consumer;
import walnoot.rhomboid.Component;
import walnoot.rhomboid.GameWorld;

public final class Entity {
    private Array<Component> components = new Array();
    private IntMap<Component> map = new IntMap();
    private GameWorld world;
    private Body body;
    public String name = "?";

    public void update() {
        this.forAllComponents(c -> c.update());
    }

    public void addComponent(Component c) {
        if (this.get(c.getClass()) != null) {
            throw new IllegalStateException("This entity already contains a component of type " + c.getClass());
        }
        for (Component component : this.components) {
            component.newComponent(c);
            c.newComponent(component);
        }
        this.components.add(c);
        c.addTo(this);
        c.setWorld(this.world, this.body);
        this.map.put(c.getClass().hashCode(), c);
    }

    public void removeComponent(Component c) {
        if (!this.components.removeValue(c, true)) {
            throw new IllegalStateException("This entity does not contain a component of type " + c.getClass());
        }
        c.setWorld(null, null);
        c.e = null;
        this.map.remove(c.getClass().hashCode());
    }

    public <T extends Component> T get(Class<T> clazz) {
        return (T)((Component)this.map.get(clazz.hashCode(), null));
    }

    public boolean has(Class<? extends Component> clazz) {
        return this.get(clazz) != null;
    }

    public void forAllComponents(Consumer<Component> c) {
        int i = 0;
        while (i < this.components.size) {
            c.accept(this.components.get(i));
            ++i;
        }
    }

    public void setWorld(GameWorld world, Body body) {
        this.world = world;
        this.body = body;
        this.forAllComponents(c -> c.setWorld(world, body));
    }

    public void beginContact(Contact contact, Entity other) {
        this.forAllComponents(c -> c.beginContact(contact, other));
    }

    public void endContact(Contact contact, Entity other) {
        this.forAllComponents(c -> c.endContact(contact, other));
    }

    public void onRemove() {
        this.forAllComponents(c -> c.onRemove());
    }

    public float getX() {
        return this.body.getPosition().x;
    }

    public float getY() {
        return this.body.getPosition().y;
    }

    public void setPos(Vector2 pos) {
        this.body.setTransform(pos, this.body.getAngle());
    }

    public Body getBody() {
        return this.body;
    }
}

