/*
 * Decompiled with CFR 0.152.
 */
package walnoot.libgdxutils.input;

import com.badlogic.gdx.Gdx;
import com.badlogic.gdx.InputAdapter;
import com.badlogic.gdx.files.FileHandle;
import com.badlogic.gdx.graphics.Camera;
import com.badlogic.gdx.math.Vector2;
import com.badlogic.gdx.math.Vector3;
import com.badlogic.gdx.utils.Array;
import com.badlogic.gdx.utils.Json;
import walnoot.libgdxutils.input.Key;

public class InputHandler
extends InputAdapter {
    private Array<Key> keys = new Array();
    private Vector3 tmp = new Vector3();

    public void update() {
        for (Key key : this.keys) {
            key.setJustTouched(false);
        }
    }

    public static InputHandler read(FileHandle file) {
        return new Json().fromJson(InputHandler.class, file);
    }

    public void write(FileHandle file) {
        new Json().toJson((Object)this, file);
    }

    public Key getKey(String name) {
        for (Key key : this.keys) {
            if (!key.getName().equals(name)) continue;
            return key;
        }
        return null;
    }

    public Vector2 getMousePosition(Camera camera, Vector2 result) {
        this.tmp.set(Gdx.input.getX(), Gdx.input.getY(), 0.0f);
        camera.unproject(this.tmp);
        return result.set(this.tmp.x, this.tmp.y);
    }

    @Override
    public boolean keyDown(int keycode) {
        for (Key key : this.keys) {
            if (!key.contains(keycode)) continue;
            key.setJustTouched(true);
        }
        return false;
    }

    public void addKey(Key key) {
        this.keys.add(key);
    }

    public Array<Key> getKeys() {
        return this.keys;
    }
}

