/*
 * Decompiled with CFR 0.152.
 */
package walnoot.libgdxutils;

import com.badlogic.gdx.utils.Array;
import java.util.Iterator;

public class Scheduler {
    private float fps;
    private Array<ScheduledEvent> events = new Array(false, 16);

    public Scheduler(float delta) {
        this.fps = delta;
    }

    public void update() {
        Iterator<ScheduledEvent> iterator = this.events.iterator();
        while (iterator.hasNext()) {
            ScheduledEvent event;
            ScheduledEvent scheduledEvent = event = iterator.next();
            scheduledEvent.ticksLeft = scheduledEvent.ticksLeft - 1;
            event.callback.reportProgress(1.0f - (float)event.ticksLeft / this.fps / event.time, event.isDone(), event.argument);
        }
    }

    public void addScheduledEvent(SchedulerCallback callback, float time, Object argument) {
        ScheduledEvent event = this.getFreeEvent();
        event.callback = callback;
        event.time = time;
        event.ticksLeft = (int)(time * this.fps);
        event.argument = argument;
    }

    private ScheduledEvent getFreeEvent() {
        ScheduledEvent event2;
        for (ScheduledEvent event2 : this.events) {
            if (!event2.isDone()) continue;
            return event2;
        }
        event2 = new ScheduledEvent();
        this.events.add(event2);
        return event2;
    }

    private class ScheduledEvent {
        private int ticksLeft;
        private float time;
        private SchedulerCallback callback;
        private Object argument;

        private ScheduledEvent() {
        }

        private boolean isDone() {
            return this.ticksLeft <= 0;
        }
    }

    public static interface SchedulerCallback {
        public void reportProgress(float var1, boolean var2, Object var3);
    }
}

