/*
 * Decompiled with CFR 0.152.
 */
package walnoot.libgdxutils;

import com.badlogic.gdx.Gdx;
import com.badlogic.gdx.graphics.Color;
import com.badlogic.gdx.graphics.OrthographicCamera;
import com.badlogic.gdx.graphics.Pixmap;
import com.badlogic.gdx.graphics.Texture;
import com.badlogic.gdx.graphics.g2d.SpriteBatch;
import com.badlogic.gdx.graphics.g2d.TextureRegion;
import com.badlogic.gdx.graphics.glutils.FrameBuffer;
import com.badlogic.gdx.graphics.glutils.ShaderProgram;
import walnoot.libgdxutils.RenderContext;

public class BlurEffect {
    private FrameBuffer blurTargetA;
    private FrameBuffer blurTargetB;
    private TextureRegion fboRegion;
    private ShaderProgram shader;
    private SpriteBatch batch = new SpriteBatch(1);
    private OrthographicCamera cam;
    private int dirLocation;
    float downScale = 1.0f;
    private float blurFactor = 4.0f;
    private RenderContext context;
    private Color tint = Color.WHITE;

    public void create() {
        this.shader = new ShaderProgram(Gdx.files.classpath("walnoot/libgdxutils/shaders/default.vertex"), Gdx.files.classpath("walnoot/libgdxutils/shaders/blur.fragment"));
        if (this.shader.getLog().length() != 0) {
            System.out.println(this.shader.getLog());
        }
        this.dirLocation = this.shader.getUniformLocation("dir");
    }

    private void resizeBatch(int width, int height) {
        this.cam.setToOrtho(false, width, height);
        this.batch.setProjectionMatrix(this.cam.combined);
    }

    public void begin(RenderContext renderContext) {
        if (this.isActive()) {
            throw new IllegalStateException("Need to call end() before begin()");
        }
        this.context = renderContext;
        this.context.setCurrentTarget(this.blurTargetA);
        this.batch.setShader(null);
        this.resizeBatch(Gdx.graphics.getWidth(), Gdx.graphics.getHeight());
        this.batch.begin();
    }

    public void end() {
        this.batch.flush();
        this.context.endCurruntTarget();
        this.genMipMaps(this.blurTargetA);
        this.batch.setShader(this.shader);
        int width = Gdx.graphics.getWidth();
        int height = Gdx.graphics.getHeight();
        this.shader.setUniformf(this.dirLocation, this.blurFactor * this.downScale / (float)width, 0.0f);
        this.context.setCurrentTarget(this.blurTargetB);
        this.fboRegion.setTexture((Texture)this.blurTargetA.getColorBufferTexture());
        this.batch.draw(this.fboRegion, 0.0f, 0.0f, (float)width / this.downScale, (float)height / this.downScale);
        this.batch.flush();
        this.context.endCurruntTarget();
        this.resizeBatch(width, height);
        this.shader.setUniformf(this.dirLocation, 0.0f, this.blurFactor / (float)width);
        this.fboRegion.setTexture((Texture)this.blurTargetB.getColorBufferTexture());
        this.batch.setColor(this.tint);
        this.batch.draw(this.fboRegion, 0.0f, 0.0f, (float)width * this.downScale, (float)height * this.downScale);
        this.batch.setColor(Color.WHITE);
        this.batch.setShader(null);
        this.batch.end();
        this.context = null;
    }

    private void genMipMaps(FrameBuffer buffer) {
        ((Texture)buffer.getColorBufferTexture()).bind();
        Gdx.gl20.glGenerateMipmap(3553);
    }

    public void resize(int width, int height) {
        if (this.blurTargetA != null) {
            this.blurTargetA.dispose();
        }
        if (this.blurTargetB != null) {
            this.blurTargetB.dispose();
        }
        this.blurTargetA = new MipMapFrameBuffer(Pixmap.Format.RGBA8888, width, height, true);
        this.blurTargetB = new FrameBuffer(Pixmap.Format.RGBA8888, width, height, true);
        this.fboRegion = new TextureRegion((Texture)this.blurTargetA.getColorBufferTexture());
        this.fboRegion.flip(false, true);
        this.cam = new OrthographicCamera(Gdx.graphics.getWidth(), Gdx.graphics.getHeight());
        this.cam.setToOrtho(false);
    }

    public void setTint(Color tint) {
        this.tint = tint;
    }

    public void setDownScale(float downScale) {
        this.downScale = downScale;
    }

    public void setBlurFactor(float blurFactor) {
        this.blurFactor = blurFactor;
    }

    public void dispose() {
        this.blurTargetA.dispose();
        this.blurTargetB.dispose();
        this.shader.dispose();
    }

    public boolean isActive() {
        return this.context != null;
    }

    public FrameBuffer getRenderTarget() {
        return this.blurTargetA;
    }

    private class MipMapFrameBuffer
    extends FrameBuffer {
        public MipMapFrameBuffer(Pixmap.Format format, int width, int height, boolean hasDepth) {
            super(format, width, height, hasDepth);
        }

        protected void setupTexture() {
            this.colorTexture = new Texture(this.width, this.height, this.format);
            ((Texture)this.colorTexture).setFilter(Texture.TextureFilter.MipMapLinearLinear, Texture.TextureFilter.Linear);
            ((Texture)this.colorTexture).setWrap(Texture.TextureWrap.ClampToEdge, Texture.TextureWrap.ClampToEdge);
        }
    }
}

