/*
 * Decompiled with CFR 0.152.
 */
package walnoot.tag13.world.entities;

import com.badlogic.gdx.graphics.Color;
import com.badlogic.gdx.math.MathUtils;
import com.badlogic.gdx.utils.Pool;
import walnoot.tag13.world.entities.Entity;

public class RainEntity
extends Entity {
    private static final float WIDTH = 0.02f;
    private static final float HEIGHT = 1.0f;
    private static final float FALL_SPEED = 20.0f;
    private static final float DESPAWN_HEIGHT = -20.0f;
    private static final int SPLASH_TIME = 7;
    private int splashStateTimer = 0;
    private boolean splash = false;
    private final Pool<RainEntity> pool;
    private Color bottomColor;
    private Color topColor;

    public RainEntity(Pool<RainEntity> pool) {
        super(0.0f, 0.0f, 0.02f, 1.0f);
        this.pool = pool;
    }

    public void init() {
        this.splashStateTimer = 0;
        this.splash = false;
        this.removed = false;
    }

    @Override
    public void updateLogic() {
        if (this.splash) {
            ++this.splashStateTimer;
        } else {
            this.y -= 0.33333334f + MathUtils.random(-0.1f, 0.1f);
        }
        Entity hit = this.world.hits(this);
        if (hit != null) {
            this.splash = true;
            this.y = hit.y + hit.height;
            hit.onRainHit(this);
        }
        if (this.splashStateTimer > 7 || this.y < -20.0f) {
            this.removed = true;
        }
    }

    @Override
    public void render() {
        if (this.splash) {
            this.renderer.rect(this.centerX() - 0.04f, this.y, 0.08f, 0.08f, this.bottomColor, this.bottomColor, this.bottomColor, this.bottomColor);
        } else {
            this.renderer.rect(this.x, this.y, this.width, this.height, this.bottomColor, this.bottomColor, this.topColor, this.topColor);
        }
    }

    public void setColor(Color color) {
        this.bottomColor = color;
        this.topColor = new Color(color);
        this.topColor.a = 0.0f;
    }

    @Override
    public void onRemove() {
        this.pool.free(this);
    }

    @Override
    public boolean isPersistent() {
        return false;
    }

    @Override
    public boolean isSolid() {
        return false;
    }
}

