/*
 * Decompiled with CFR 0.152.
 */
package walnoot.tag13.world.entities;

import com.badlogic.gdx.graphics.Color;
import walnoot.tag13.Input;
import walnoot.tag13.states.GameState;
import walnoot.tag13.world.entities.DynamicEntity;
import walnoot.tag13.world.entities.RainEntity;

public class PlayerEntity
extends DynamicEntity {
    private static final float JUMP_SPEED = 6.0f;
    private static final float JUMP_BOOST = 40.0f;
    private static final int BOOST_TIME = 29;
    private static final float HOR_SPEED = 6.0f;
    private static final Color COLOR = new Color(-218973697);
    private static final int HIT_TIME = 14;
    private static final float RESPAWN_HEIGHT = -8.0f;
    private int jumpTicks;
    private int jumpCount;
    private boolean jumping;
    private int hitTimer;
    private boolean respawning;

    public PlayerEntity() {
        super(-1.0f, 1.0f, 1.0f, 1.0f);
    }

    @Override
    public void updateLogic() {
        this.handleInput();
        if (this.y < -8.0f && !this.respawning) {
            this.die();
        }
        if (this.hitTimer > 0) {
            --this.hitTimer;
            this.height -= 0.0020833334f * this.world.getRainStrength();
            if (this.height < 0.0f) {
                this.die();
                this.height = 0.0f;
            }
        }
    }

    private void handleInput() {
        float turnSpeed = this.touchGround ? 0.5f : 0.05f;
        boolean walkLeft = Input.i.right.isTouched();
        boolean walkRight = Input.i.left.isTouched();
        if (walkLeft) {
            this.velX += (6.0f - this.velX) * turnSpeed;
        }
        if (walkRight) {
            this.velX += (-6.0f - this.velX) * turnSpeed;
        }
        if (!walkLeft && !walkRight && this.touchGround) {
            this.velX = (float)((double)this.velX * 0.7);
        }
        if (Input.i.jump.justTouched && (this.touchGround || this.jumpCount < 1)) {
            this.jumping = true;
            ++this.jumpCount;
        }
        if (!Input.i.jump.isTouched()) {
            this.jumping = false;
        }
        if (this.touchGround) {
            this.jumpCount = 0;
        }
        this.jumpTicks = this.jumping ? ++this.jumpTicks : 0;
        if (this.jumpTicks == 1) {
            this.velY = 6.0f;
        } else if (this.jumpTicks > 1 && this.jumpTicks < 29) {
            this.velY += 0.6666667f * (1.0f - (float)this.jumpTicks / 29.0f);
        }
    }

    private void die() {
        if (!this.respawning || this.world.isLoadingNextLevel()) {
            this.world.respawn();
            this.respawning = true;
        }
    }

    public void onRespawn() {
        this.respawning = false;
        this.height = 1.0f;
    }

    @Override
    public void render() {
        this.renderer.rect(this.x, this.y, this.width, this.height, COLOR, COLOR, COLOR, COLOR);
    }

    @Override
    public void onRainHit(RainEntity rainEntity) {
        if (!GameState.debug) {
            this.hitTimer = 14;
        }
    }

    public void fillHealth() {
        this.height = 1.0f;
    }
}

