/*
 * Decompiled with CFR 0.152.
 */
package walnoot.tag13.world.entities;

import com.badlogic.gdx.audio.Sound;
import com.badlogic.gdx.graphics.Color;
import walnoot.tag13.Assets;
import walnoot.tag13.Util;
import walnoot.tag13.world.entities.Entity;
import walnoot.tag13.world.entities.PlayerEntity;

public abstract class PickupEntity
extends Entity {
    public static final float RADIUS = 0.25f;
    public static final float HALF_RADIUS = 0.125f;
    private static final float ROT_SPEED = 180.0f;
    public static final String SOUND_PATH = "sounds/pickup.wav";
    private float rotation;
    private final Color color;

    public PickupEntity(float x, float y, Color color) {
        super(x, y, 0.0f, 0.0f);
        this.color = color;
    }

    @Override
    public void updateLogic() {
        Entity hit = this.world.hits(this);
        if (hit != null && hit instanceof PlayerEntity) {
            this.onPickup((PlayerEntity)hit);
            Sound sound = Assets.manager.get(SOUND_PATH, Sound.class);
            if (sound != null) {
                sound.play();
            }
            this.removed = true;
        }
        this.rotation += 3.0000002f;
    }

    protected abstract void onPickup(PlayerEntity var1);

    @Override
    public void render() {
        Util.renderStar(this.renderer, this.x, this.y, this.color, this.rotation, 0.25f);
    }

    @Override
    public boolean isSolid() {
        return false;
    }

    @Override
    public boolean isPersistent() {
        return false;
    }
}

