/*
 * Decompiled with CFR 0.152.
 */
package walnoot.tag13.world.entities;

import com.badlogic.gdx.math.Vector2;
import com.badlogic.gdx.utils.JsonValue;
import walnoot.tag13.world.entities.DynamicEntity;
import walnoot.tag13.world.entities.Entity;
import walnoot.tag13.world.entities.PlatformEntity;

public class MovingPlatform
extends PlatformEntity {
    private final Vector2[] points;
    private float dist;
    private int index;
    private float speed;
    private Vector2 tmp1 = new Vector2();
    private Vector2 tmp2 = new Vector2();

    public MovingPlatform(JsonValue json) {
        this(json.getFloat("width", 0.0f), json.getFloat("height", 0.0f), MovingPlatform.parsePoints(json.get("points")), json.getFloat("speed", 1.0f), json.getFloat("start", 0.0f));
    }

    private static Vector2[] parsePoints(JsonValue jsonValue) {
        Vector2[] result = new Vector2[jsonValue.size];
        int i = 0;
        while (i < jsonValue.size) {
            JsonValue point = jsonValue.get(i);
            result[i] = new Vector2(point.getFloat(0), point.getFloat(1));
            ++i;
        }
        return result;
    }

    public MovingPlatform(float width, float height, Vector2[] points, float speed, float start) {
        super(0.0f, 0.0f, width, height);
        this.points = points;
        this.speed = speed;
        this.dist = start;
    }

    @Override
    public void updateLogic() {
        DynamicEntity dynamic;
        this.dist += this.speed * 0.016666668f;
        float curLength = this.getCurrentSegmentLength();
        while (this.dist > curLength) {
            this.dist -= curLength;
            ++this.index;
            curLength = this.getCurrentSegmentLength();
        }
        Vector2 startPoint = this.getPoint(this.index);
        Vector2 endPoint = this.getPoint(this.index + 1);
        Vector2 pos = this.tmp1.set(startPoint).lerp(endPoint, this.dist / curLength);
        Vector2 velocity = this.tmp2.set(endPoint).sub(startPoint).nor().scl(this.speed);
        this.velX = velocity.x;
        this.velY = velocity.y;
        Entity rider = this.world.getEntity(this.x, this.y + this.height, this.width, 0.1f);
        DynamicEntity dynamicEntity = dynamic = rider instanceof DynamicEntity ? (DynamicEntity)rider : null;
        if (dynamic != null) {
            dynamic.rideVelX = this.velX;
            dynamic.rideVelY = this.velY;
        }
        this.x = pos.x;
        this.y = pos.y;
    }

    private float getCurrentSegmentLength() {
        return this.getPoint(this.index).dst(this.getPoint(this.index + 1));
    }

    private Vector2 getPoint(int index) {
        return this.points[index % this.points.length];
    }
}

