/*
 * Decompiled with CFR 0.152.
 */
package walnoot.tag13.world.entities;

import com.badlogic.gdx.graphics.Color;
import com.badlogic.gdx.graphics.OrthographicCamera;
import com.badlogic.gdx.graphics.Texture;
import com.badlogic.gdx.graphics.g2d.Sprite;
import walnoot.tag13.Assets;
import walnoot.tag13.states.GameState;
import walnoot.tag13.world.entities.Entity;

public class HintEntity
extends Entity {
    private static final float Y_OFFSET = 5.0f;
    private static final Color DEBUG_COLOR = new Color(0.0f, 0.0f, 1.0f, 0.2f);
    private static final int FADE_TIME = 59;
    private final String hintAsset;
    private Sprite sprite;
    private int timer;
    private int fadeTimer;

    public HintEntity(float x, float y, float width, float height, String hintAsset, float delay) {
        super(x, y, width, height);
        this.hintAsset = hintAsset;
        this.timer = (int)(delay / 0.016666668f);
        Assets.manager.load(hintAsset, Texture.class);
    }

    @Override
    public void updateLogic() {
        if (this.timer > 0 && this.hits(this.world.getPlayer())) {
            --this.timer;
        }
        if (this.canDisplay() && this.fadeTimer < 59) {
            ++this.fadeTimer;
        }
        if (!this.canDisplay() && this.fadeTimer > 0) {
            --this.fadeTimer;
        }
        if (Assets.manager.isLoaded(this.hintAsset) && this.sprite == null) {
            this.sprite = new Sprite(Assets.manager.get(this.hintAsset, Texture.class));
            this.sprite.setSize(4.0f, 2.0f);
        }
    }

    @Override
    public void render() {
        if (GameState.debug) {
            this.renderer.rect(this.x, this.y, this.width, this.height, DEBUG_COLOR, DEBUG_COLOR, DEBUG_COLOR, DEBUG_COLOR);
        }
    }

    @Override
    public void renderBatch() {
        if (this.sprite != null && this.canDisplay() || this.fadeTimer > 0) {
            OrthographicCamera camera = this.world.getCamera();
            this.sprite.setX(camera.position.x - this.sprite.getWidth() * 0.5f);
            this.sprite.setY(camera.position.y - this.sprite.getHeight() * 0.5f - 5.0f);
            this.sprite.setAlpha((float)this.fadeTimer / 59.0f);
            this.sprite.draw(this.batch);
        }
    }

    private boolean canDisplay() {
        return this.hits(this.world.getPlayer()) && this.timer == 0;
    }

    @Override
    public boolean isPersistent() {
        return false;
    }

    @Override
    public boolean isSolid() {
        return false;
    }
}

