/*
 * Decompiled with CFR 0.152.
 */
package walnoot.tag13.world.entities;

import com.badlogic.gdx.Preferences;
import com.badlogic.gdx.graphics.Color;
import com.badlogic.gdx.utils.JsonValue;
import walnoot.tag13.TAG13Game;
import walnoot.tag13.Util;
import walnoot.tag13.states.CreditsState;
import walnoot.tag13.world.entities.Entity;
import walnoot.tag13.world.entities.StarEntity;

public class GoalEntity
extends Entity {
    private static final Color COLOR = new Color(1.0f, 1.0f, 1.0f, 0.1f);
    private String nextLevel;
    private boolean finalLevel;

    public GoalEntity(JsonValue json) {
        JsonValue pos = json.get("pos");
        this.x = pos.getFloat(0);
        this.y = pos.getFloat(1);
        this.width = pos.getFloat(2);
        this.height = pos.getFloat(3);
        this.finalLevel = json.getBoolean("final", false);
        this.nextLevel = json.getString("nextLevel", null);
    }

    @Override
    public void updateLogic() {
        if (this.world.hits(this) == this.world.getPlayer()) {
            Preferences prefs;
            StarEntity star = this.world.getStar();
            if (star != null && star.isPickedUp()) {
                prefs = Util.getPrefs();
                prefs.putBoolean("star_" + this.world.getCurrentLevel(), true);
            }
            if (this.finalLevel && !this.world.isLoadingNextLevel()) {
                TAG13Game.instance.setState(new CreditsState(TAG13Game.instance.getState()));
                prefs = Util.getPrefs();
                prefs.putBoolean("stars_unlocked", true);
                prefs.flush();
            }
            this.world.transitionLoad(this.nextLevel);
        }
    }

    @Override
    public void render() {
        this.renderer.rect(this.x, this.y, this.width, this.height, COLOR, COLOR, COLOR, COLOR);
    }

    @Override
    public boolean isPersistent() {
        return false;
    }

    @Override
    public boolean isSolid() {
        return false;
    }
}

