/*
 * Decompiled with CFR 0.152.
 */
package walnoot.tag13.world.entities;

import com.badlogic.gdx.graphics.g2d.SpriteBatch;
import com.badlogic.gdx.graphics.glutils.ShapeRenderer;
import walnoot.tag13.Util;
import walnoot.tag13.world.World;
import walnoot.tag13.world.entities.RainEntity;

public abstract class Entity {
    public float x;
    public float y;
    public float width;
    public float height;
    public float velX;
    public float velY;
    public boolean removed;
    public World world;
    public ShapeRenderer renderer;
    public SpriteBatch batch;

    public Entity() {
    }

    public Entity(float x, float y, float width, float height) {
        this.x = x;
        this.y = y;
        this.width = width;
        this.height = height;
    }

    public void updateLogic() {
    }

    public void updatePhysics() {
    }

    public void render() {
        this.renderer.setColor(0.0f, 0.0f, 0.0f, 1.0f);
        this.renderer.rect(this.x, this.y, this.width, this.height);
    }

    public void renderBatch() {
    }

    public float centerX() {
        return this.x + this.width * 0.5f;
    }

    public float centerY() {
        return this.y + this.height * 0.5f;
    }

    public boolean isSolid() {
        return true;
    }

    public boolean isPersistent() {
        return true;
    }

    public boolean hits(Entity other) {
        return Util.collides(this.x, this.y, this.width, this.height, other.x, other.y, other.width, other.height);
    }

    public void onCreate() {
    }

    public void onRemove() {
    }

    public void onRainHit(RainEntity rainEntity) {
    }
}

