/*
 * Decompiled with CFR 0.152.
 */
package walnoot.tag13.world.entities;

import walnoot.tag13.world.entities.Entity;

public class DynamicEntity
extends Entity {
    public float rideVelX;
    public float rideVelY;
    private static final float GRAVITY = 25.0f;
    protected boolean touchGround;
    protected boolean touchRight;
    protected boolean touchLeft;

    public DynamicEntity() {
    }

    public DynamicEntity(float x, float y, float width, float height) {
        super(x, y, width, height);
    }

    @Override
    public final void updatePhysics() {
        this.moveY();
        this.moveX();
        this.touchGround = this.world.getEntity(this.x, this.y - 0.1f, this.width, 0.1f, this) != null;
    }

    private void moveX() {
        this.x += (this.velX + this.rideVelX) * 0.016666668f;
        this.touchLeft = false;
        this.touchRight = false;
        Entity hit = this.world.hits(this);
        if (hit != null) {
            if (this.velX + this.rideVelX - hit.velX > 0.0f) {
                this.x = hit.x - this.width;
                this.touchRight = true;
            }
            if (this.velX + this.rideVelX - hit.velX < 0.0f) {
                this.x = hit.x + hit.width;
                this.touchLeft = true;
            }
            this.velX = 0.0f;
        }
        this.rideVelX = 0.0f;
    }

    private void moveY() {
        if (this.hasGravity()) {
            this.velY -= 0.4166667f;
        }
        this.y += (this.velY + this.rideVelY) * 0.016666668f;
        this.touchGround = false;
        Entity hit = this.world.hits(this);
        if (hit != null) {
            if (this.velY + this.rideVelY - hit.velY > 0.0f) {
                this.y = hit.y - this.height;
            }
            if (this.velY + this.rideVelY - hit.velY < 0.0f) {
                this.y = hit.y + hit.height;
            }
            this.velY = 0.0f;
        }
        this.rideVelY = 0.0f;
    }

    protected boolean hasGravity() {
        return true;
    }
}

