/*
 * Decompiled with CFR 0.152.
 */
package walnoot.tag13.world;

import com.badlogic.gdx.Gdx;
import com.badlogic.gdx.Preferences;
import com.badlogic.gdx.graphics.OrthographicCamera;
import com.badlogic.gdx.graphics.g2d.SpriteBatch;
import com.badlogic.gdx.graphics.glutils.ShapeRenderer;
import com.badlogic.gdx.math.MathUtils;
import com.badlogic.gdx.utils.Array;
import com.badlogic.gdx.utils.JsonReader;
import com.badlogic.gdx.utils.JsonValue;
import walnoot.tag13.Input;
import walnoot.tag13.Util;
import walnoot.tag13.states.GameState;
import walnoot.tag13.world.BackgroundHandler;
import walnoot.tag13.world.FadeHandler;
import walnoot.tag13.world.HiddenPlatform;
import walnoot.tag13.world.RainHandler;
import walnoot.tag13.world.SoundHandler;
import walnoot.tag13.world.entities.Entity;
import walnoot.tag13.world.entities.GoalEntity;
import walnoot.tag13.world.entities.HealthEntity;
import walnoot.tag13.world.entities.HintEntity;
import walnoot.tag13.world.entities.MovingPlatform;
import walnoot.tag13.world.entities.PickupEntity;
import walnoot.tag13.world.entities.PlatformEntity;
import walnoot.tag13.world.entities.PlayerEntity;
import walnoot.tag13.world.entities.StarEntity;

public class World {
    private static final int THUNDER_RANGE_START = 8;
    private static final int THUNDER_RANGE_END = 25;
    private static final float CAMERA_Y_OFFSET = 2.0f;
    public static final int TRANSITION_TIME = 59;
    private Array<Entity> entities = new Array();
    private BackgroundHandler background = new BackgroundHandler();
    private SoundHandler sound = new SoundHandler();
    private FadeHandler fade = new FadeHandler();
    private RainHandler rainHandler;
    private ShapeRenderer renderer = new ShapeRenderer();
    private SpriteBatch batch = new SpriteBatch();
    private OrthographicCamera camera = new OrthographicCamera();
    private PlayerEntity player;
    private StarEntity star;
    private Array<PickupEntity> pickups = new Array();
    private int thunderTimer = 479;
    private int respawnTimer;
    private float spawnX;
    private float spawnY;
    private String nextLevel;
    private int nextLevelTimer;
    private float rainStrength;
    private String currentLevel;

    public World() {
        this.player = new PlayerEntity();
        this.addEntity(this.player);
        this.rainHandler = new RainHandler(this, this.player);
    }

    public void load(String level) {
        JsonValue pos;
        JsonValue health;
        JsonValue movingPlatforms;
        System.out.println("loading level: " + level);
        this.currentLevel = level;
        Preferences prefs = Util.getPrefs();
        prefs.putBoolean("unlocked_" + level, true);
        prefs.putString("current_level", level);
        boolean starsUnlocked = prefs.getBoolean("stars_unlocked", false);
        prefs.flush();
        for (Entity e : this.entities) {
            if (e.isPersistent()) continue;
            e.removed = true;
        }
        this.pickups.clear();
        JsonValue jsonValue = new JsonReader().parse(Gdx.files.internal(level));
        JsonValue platforms = jsonValue.get("platforms");
        JsonValue platform = platforms.child;
        while (platform != null) {
            String type;
            float x = platform.getFloat(0);
            float y = platform.getFloat(1);
            float width = platform.getFloat(2);
            float height = platform.getFloat(3);
            String string = type = platform.size >= 5 ? platform.getString(4) : null;
            if ("h".equals(type)) {
                this.addEntity(new HiddenPlatform(x, y, width, height));
            } else {
                this.addEntity(new PlatformEntity(x, y, width, height));
            }
            platform = platform.next;
        }
        JsonValue hint = jsonValue.get("hint");
        if (hint != null) {
            JsonValue pos2 = hint.get("pos");
            float x = pos2.getFloat(0);
            float y = pos2.getFloat(1);
            float width = pos2.getFloat(2);
            float height = pos2.getFloat(3);
            this.addEntity(new HintEntity(x, y, width, height, hint.getString("asset"), hint.getFloat("delay", 0.0f)));
        }
        if ((movingPlatforms = jsonValue.get("movingplatforms")) != null) {
            for (JsonValue movingPlatform : movingPlatforms) {
                this.addEntity(new MovingPlatform(movingPlatform));
            }
        }
        if ((health = jsonValue.get("health")) != null) {
            for (JsonValue healthPos : health) {
                HealthEntity healthEntity = new HealthEntity(healthPos.getFloat(0), healthPos.getFloat(1));
                this.addEntity(healthEntity);
                this.pickups.add(healthEntity);
            }
        }
        this.addEntity(new GoalEntity(jsonValue.get("goal")));
        this.star = null;
        if (starsUnlocked && (pos = jsonValue.get("star")) != null) {
            this.star = new StarEntity(pos.getFloat(0), pos.getFloat(1));
            this.addEntity(this.star);
            this.pickups.add(this.star);
        }
        this.rainStrength = jsonValue.getFloat("rainStrength", 1.0f);
        this.rainHandler.setColor(jsonValue.getString("rainColor", "FFFFFF"));
        JsonValue spawn = jsonValue.get("spawn");
        this.spawnX = spawn.getFloat(0);
        this.spawnY = spawn.getFloat(1);
        this.player.x = this.spawnX;
        this.player.y = this.spawnY;
        this.camera.position.x = this.player.centerX();
        this.camera.position.y = this.player.centerY() + 2.0f;
        this.player.onRespawn();
    }

    public void update() {
        if (GameState.debug && Input.i.reload.justTouched) {
            this.transitionLoad(this.currentLevel);
        }
        this.rainHandler.update();
        this.background.update();
        if (this.respawnTimer > 0) {
            --this.respawnTimer;
            if (this.respawnTimer == 0) {
                this.player.x = this.spawnX;
                this.player.y = this.spawnY;
                this.player.onRespawn();
                for (PickupEntity e : this.pickups) {
                    if (!e.removed) continue;
                    e.removed = false;
                    this.addEntity(e);
                }
            }
        }
        if (this.nextLevelTimer > 0) {
            --this.nextLevelTimer;
            if (this.nextLevelTimer == 0) {
                this.load(this.nextLevel);
                this.nextLevel = null;
            }
        }
        if (this.thunderTimer == 0) {
            this.thunderTimer = (int)((float)MathUtils.random(8, 25) / 0.016666668f);
            this.sound.onThunder();
            this.background.onThunder();
        }
        --this.thunderTimer;
        int i = 0;
        while (i < this.entities.size) {
            Entity entity = this.entities.get(i);
            if (entity.removed) {
                entity.onRemove();
                this.entities.removeIndex(i);
                --i;
            } else {
                entity.updateLogic();
            }
            ++i;
        }
        i = 0;
        while (i < this.entities.size) {
            this.entities.get(i).updatePhysics();
            ++i;
        }
        this.camera.position.x += (this.player.centerX() - this.camera.position.x) * 0.016666668f * 4.0f;
        this.camera.position.y += (this.player.centerY() + 2.0f - this.camera.position.y) * 0.016666668f * 4.0f;
    }

    public void render() {
        Gdx.gl20.glEnable(3042);
        Gdx.gl20.glBlendFunc(770, 771);
        this.camera.update();
        this.renderer.setProjectionMatrix(this.camera.combined);
        this.batch.setProjectionMatrix(this.camera.combined);
        this.renderer.begin(ShapeRenderer.ShapeType.Filled);
        this.background.render(this.renderer, this.camera);
        for (Entity entity : this.entities) {
            if (!Util.collides(entity.x, entity.y, entity.width, entity.height, this.camera.position.x - this.camera.viewportWidth * this.camera.zoom * 0.5f, this.camera.position.y - this.camera.viewportHeight * this.camera.zoom * 0.5f, this.camera.viewportWidth * this.camera.zoom, this.camera.viewportHeight * this.camera.zoom)) continue;
            entity.render();
        }
        this.fade.render(this.renderer, this, this.camera);
        this.renderer.end();
        this.batch.begin();
        for (Entity e : this.entities) {
            e.renderBatch();
        }
        this.batch.end();
    }

    public void transitionLoad(String nextLevel) {
        if (!this.isLoadingNextLevel()) {
            this.nextLevel = nextLevel;
            this.nextLevelTimer = 59;
        }
    }

    public void respawn() {
        this.respawnTimer = 59;
    }

    public Entity getEntity(float x, float y, float width, float height) {
        return this.getEntity(x, y, width, height, null);
    }

    public Entity getEntity(float x, float y, float width, float height, Entity exclude) {
        for (Entity entity : this.entities) {
            if (!entity.isSolid() || entity == exclude || !Util.collides(x, y, width, height, entity.x, entity.y, entity.width, entity.height)) continue;
            return entity;
        }
        return null;
    }

    public Entity hits(Entity entity) {
        return this.getEntity(entity.x, entity.y, entity.width, entity.height, entity);
    }

    public PlayerEntity getPlayer() {
        return this.player;
    }

    public StarEntity getStar() {
        return this.star;
    }

    public int getRespawnTimer() {
        return this.respawnTimer;
    }

    public int getNextLevelTimer() {
        return this.nextLevelTimer;
    }

    public boolean isLoadingNextLevel() {
        return this.nextLevel != null;
    }

    public OrthographicCamera getCamera() {
        return this.camera;
    }

    public Array<Entity> getEntities() {
        return this.entities;
    }

    public float getRainStrength() {
        return this.rainStrength;
    }

    public String getCurrentLevel() {
        return this.currentLevel;
    }

    public void addEntity(Entity e) {
        e.world = this;
        e.renderer = this.renderer;
        e.batch = this.batch;
        e.onCreate();
        this.entities.add(e);
    }

    public void resize(int width, int height) {
        System.out.printf("x: %d, y: %d\n", width, height);
        this.camera.viewportWidth = 2.0f * (float)width / (float)height;
        this.camera.viewportHeight = 2.0f;
        this.camera.zoom = 6.0f;
    }
}

