/*
 * Decompiled with CFR 0.152.
 */
package walnoot.tag13.world;

import com.badlogic.gdx.graphics.Color;
import com.badlogic.gdx.math.MathUtils;
import com.badlogic.gdx.utils.Pool;
import walnoot.tag13.world.World;
import walnoot.tag13.world.entities.PlayerEntity;
import walnoot.tag13.world.entities.RainEntity;

public class RainHandler {
    private static final float HEIGHT = 20.0f;
    private static final float RANGE = 15.0f;
    private static final float DROPS_PER_SECOND = 400.0f;
    private final World world;
    private final PlayerEntity player;
    private float unprocessedSeconds;
    private Color color;
    private Pool<RainEntity> pool = new Pool<RainEntity>(){

        @Override
        protected RainEntity newObject() {
            return new RainEntity(this);
        }
    };

    public RainHandler(World world, PlayerEntity player) {
        this.world = world;
        this.player = player;
    }

    public void setColor(String hexCode) {
        this.color = Color.valueOf(hexCode);
        this.color.a = 0.4f;
    }

    public void update() {
        this.unprocessedSeconds += 0.016666668f;
        while (this.unprocessedSeconds > 0.0025f) {
            this.unprocessedSeconds -= 0.0025f;
            RainEntity rain = this.pool.obtain();
            rain.x = this.player.centerX() + MathUtils.random(-15.0f, 15.0f);
            rain.y = 20.0f;
            rain.setColor(this.color);
            rain.init();
            this.world.addEntity(rain);
        }
    }
}

