/*
 * Decompiled with CFR 0.152.
 */
package walnoot.tag13.world;

import com.badlogic.gdx.Gdx;
import com.badlogic.gdx.InputAdapter;
import com.badlogic.gdx.math.Vector2;
import walnoot.tag13.Util;
import walnoot.tag13.states.GameState;
import walnoot.tag13.world.World;
import walnoot.tag13.world.entities.Entity;
import walnoot.tag13.world.entities.PlatformEntity;

public class EditorInput
extends InputAdapter {
    private final World world;
    private Vector2 startPos;

    public EditorInput(World world) {
        this.world = world;
    }

    @Override
    public boolean keyDown(int keycode) {
        if (keycode == 244) {
            boolean bl = GameState.debug = !GameState.debug;
        }
        if (GameState.debug && Gdx.input.isKeyPressed(129) && keycode == 47) {
            for (Entity e : this.world.getEntities()) {
                if (!(e instanceof PlatformEntity)) continue;
                System.out.printf(null, "[%.2f, %.2f, %.2f, %.2f],\n", Float.valueOf(e.x), Float.valueOf(e.y), Float.valueOf(e.width), Float.valueOf(e.height));
            }
        }
        return false;
    }

    @Override
    public boolean touchDown(int screenX, int screenY, int pointer, int button) {
        Vector2 worldPos = this.getWorldPos(screenX, screenY);
        if (button == 0) {
            this.startPos = worldPos;
        } else {
            this.removeBlock(worldPos);
        }
        return false;
    }

    @Override
    public boolean touchUp(int screenX, int screenY, int pointer, int button) {
        if (this.startPos != null && GameState.debug && button == 0) {
            Vector2 endPos = this.getWorldPos(screenX, screenY);
            float x = Math.min(this.startPos.x, endPos.x);
            float y = Math.min(this.startPos.y, endPos.y);
            float width = Math.abs(this.startPos.x - endPos.x);
            float height = Math.abs(this.startPos.y - endPos.y);
            if (Gdx.input.isKeyPressed(129)) {
                x = (float)Math.floor(x);
                y = (float)Math.floor(y);
                width = (float)Math.ceil(width);
                height = (float)Math.ceil(height);
            }
            this.world.addEntity(new PlatformEntity(x, y, width, height));
        }
        this.startPos = null;
        return false;
    }

    private void removeBlock(Vector2 worldPos) {
        Entity entity = this.world.getEntity(worldPos.x, worldPos.y, 0.0f, 0.0f);
        if (entity instanceof PlatformEntity) {
            entity.removed = true;
        }
    }

    private Vector2 getWorldPos(float screenX, float screenY) {
        return Util.getWorldPos(screenX, screenY, this.world.getCamera());
    }
}

