/*
 * Decompiled with CFR 0.152.
 */
package walnoot.tag13.states;

import com.badlogic.gdx.Gdx;
import com.badlogic.gdx.InputProcessor;
import com.badlogic.gdx.Preferences;
import com.badlogic.gdx.graphics.Color;
import com.badlogic.gdx.graphics.OrthographicCamera;
import com.badlogic.gdx.graphics.Texture;
import com.badlogic.gdx.graphics.g2d.Sprite;
import com.badlogic.gdx.graphics.g2d.SpriteBatch;
import com.badlogic.gdx.graphics.glutils.ShapeRenderer;
import com.badlogic.gdx.math.Vector2;
import walnoot.tag13.Input;
import walnoot.tag13.Inputs;
import walnoot.tag13.TAG13Game;
import walnoot.tag13.Util;
import walnoot.tag13.states.GameState;
import walnoot.tag13.states.State;
import walnoot.tag13.world.entities.StarEntity;

public class LevelSelectState
extends State
implements InputProcessor {
    private static final String[] LEVELS = new String[]{"level1", "level2", "level3", "level4", "level5", "level6"};
    private static final Color BACKGROUND_COLOR = new Color(0.0f, 0.0f, 0.0f, 0.4f);
    public static final Color STAR_ACTIVE_COLOR = StarEntity.COLOR;
    public static final Color STAR_INACTIVE_COLOR = Color.DARK_GRAY;
    private final GameState gameState;
    private OrthographicCamera camera = new OrthographicCamera();
    private SpriteBatch batch = new SpriteBatch();
    private ShapeRenderer shapeRenderer = new ShapeRenderer();
    private Sprite[] sprites = new Sprite[LEVELS.length];
    private boolean[] unlocked = new boolean[LEVELS.length];
    private boolean[] hasStar = new boolean[LEVELS.length];

    public LevelSelectState(GameState gameState) {
        this.gameState = gameState;
        Preferences prefs = Util.getPrefs();
        int i = 0;
        while (i < this.sprites.length) {
            Texture texture = new Texture(String.valueOf(LEVELS[i]) + ".png");
            Sprite sprite = new Sprite(texture);
            sprite.setSize(0.25f, 0.25f);
            sprite.setPosition(-0.5f + (float)(i % 2) * 1.0f, 0.5f - (float)(i / 2) * 0.5f);
            this.sprites[i] = sprite;
            this.unlocked[i] = prefs.getBoolean("unlocked_" + LEVELS[i] + ".json", false);
            this.hasStar[i] = prefs.getBoolean("star_" + LEVELS[i] + ".json", false);
            ++i;
        }
    }

    @Override
    public void create() {
        Inputs.instance.addProcessor(this);
    }

    @Override
    public void destroy() {
        Inputs.instance.removeProcessor(this);
        Sprite[] spriteArray = this.sprites;
        int n = this.sprites.length;
        int n2 = 0;
        while (n2 < n) {
            Sprite sprite = spriteArray[n2];
            sprite.getTexture().dispose();
            ++n2;
        }
    }

    @Override
    public void update() {
        if (Input.i.pause.justTouched) {
            TAG13Game.instance.setState(this.gameState);
        }
    }

    @Override
    public void render() {
        this.gameState.render();
        Gdx.gl20.glEnable(3042);
        Gdx.gl20.glBlendFunc(770, 771);
        this.shapeRenderer.begin(ShapeRenderer.ShapeType.Filled);
        Util.drawScreenRect(this.shapeRenderer, this.camera, BACKGROUND_COLOR);
        this.shapeRenderer.end();
        this.batch.begin();
        int i = 0;
        while (i < this.sprites.length) {
            this.sprites[i].draw(this.batch, this.unlocked[i] ? 1.0f : 0.5f);
            ++i;
        }
        this.batch.end();
        this.shapeRenderer.begin(ShapeRenderer.ShapeType.Filled);
        i = 0;
        while (i < this.sprites.length) {
            Sprite sprite = this.sprites[i];
            Color color = this.hasStar[i] ? STAR_ACTIVE_COLOR : STAR_INACTIVE_COLOR;
            Util.renderStar(this.shapeRenderer, sprite.getX(), sprite.getY(), color, 0.0f, 0.0625f);
            ++i;
        }
        this.shapeRenderer.end();
    }

    @Override
    public void resize(int width, int height) {
        this.camera.viewportWidth = 2.0f * (float)width / (float)height;
        this.camera.viewportHeight = 2.0f;
        this.camera.update();
        this.batch.setProjectionMatrix(this.camera.combined);
        this.shapeRenderer.setProjectionMatrix(this.camera.combined);
    }

    @Override
    public boolean keyDown(int keycode) {
        return false;
    }

    @Override
    public boolean keyUp(int keycode) {
        return false;
    }

    @Override
    public boolean keyTyped(char character) {
        return false;
    }

    @Override
    public boolean touchDown(int screenX, int screenY, int pointer, int button) {
        Vector2 worldPos = Util.getWorldPos(screenX, screenY, this.camera);
        int i = 0;
        while (i < this.sprites.length) {
            Sprite sprite = this.sprites[i];
            if (Util.collides(worldPos.x, worldPos.y, 0.0f, 0.0f, sprite.getX(), sprite.getY(), sprite.getWidth(), sprite.getHeight()) && this.unlocked[i]) {
                this.gameState.getWorld().transitionLoad(String.valueOf(LEVELS[i]) + ".json");
                TAG13Game.instance.setState(this.gameState);
            }
            ++i;
        }
        return false;
    }

    @Override
    public boolean touchUp(int screenX, int screenY, int pointer, int button) {
        return false;
    }

    @Override
    public boolean touchDragged(int screenX, int screenY, int pointer) {
        return false;
    }

    @Override
    public boolean mouseMoved(int screenX, int screenY) {
        return false;
    }

    @Override
    public boolean scrolled(int amount) {
        return false;
    }
}

