/*
 * Decompiled with CFR 0.152.
 */
package walnoot.tag13.states;

import com.badlogic.gdx.graphics.OrthographicCamera;
import com.badlogic.gdx.graphics.Texture;
import com.badlogic.gdx.graphics.g2d.Sprite;
import com.badlogic.gdx.graphics.g2d.SpriteBatch;
import walnoot.tag13.Input;
import walnoot.tag13.TAG13Game;
import walnoot.tag13.states.State;

public class CreditsState
extends State {
    private final State gameState;
    private OrthographicCamera camera = new OrthographicCamera();
    private SpriteBatch batch = new SpriteBatch();
    private Sprite sprite;

    public CreditsState(State state) {
        this.gameState = state;
        Texture texture = new Texture("credits.png");
        texture.setFilter(Texture.TextureFilter.Linear, Texture.TextureFilter.Linear);
        this.sprite = new Sprite(texture);
        this.sprite.setPosition(-1.0f, -1.0f);
        this.sprite.setSize(2.0f, 2.0f);
    }

    @Override
    public void update() {
        if (Input.i.jump.justTouched) {
            TAG13Game.instance.setState(this.gameState);
        }
    }

    @Override
    public void render() {
        this.gameState.render();
        this.batch.begin();
        this.sprite.draw(this.batch);
        this.batch.end();
    }

    @Override
    public void resize(int width, int height) {
        this.camera.viewportWidth = 2.0f * (float)width / (float)height;
        this.camera.viewportHeight = 2.0f;
        this.camera.update();
        this.batch.setProjectionMatrix(this.camera.combined);
    }
}

