/*
 * Decompiled with CFR 0.152.
 */
package walnoot.tag13;

import com.badlogic.gdx.Gdx;
import com.badlogic.gdx.Preferences;
import com.badlogic.gdx.graphics.Color;
import com.badlogic.gdx.graphics.OrthographicCamera;
import com.badlogic.gdx.graphics.glutils.ShapeRenderer;
import com.badlogic.gdx.math.Vector2;
import com.badlogic.gdx.math.Vector3;

public class Util {
    public static boolean collides(float x1, float y1, float width1, float height1, float x2, float y2, float width2, float height2) {
        return x1 + width1 > x2 && x1 < x2 + width2 && y1 + height1 > y2 && y1 < y2 + height2;
    }

    public static void drawScreenRect(ShapeRenderer renderer, OrthographicCamera camera, Color color) {
        float halfWidth = camera.viewportWidth * camera.zoom * 0.5f;
        float halfHeight = camera.viewportHeight * camera.zoom * 0.5f;
        renderer.rect(camera.position.x - halfWidth, camera.position.y - halfHeight, halfWidth * 2.0f, halfHeight * 2.0f, color, color, color, color);
    }

    public static Preferences getPrefs() {
        return Gdx.app.getPreferences("tag13");
    }

    public static Vector2 getWorldPos(float screenX, float screenY, OrthographicCamera camera) {
        Vector3 screenPos = new Vector3(screenX, screenY, 0.0f);
        Vector3 worldPos = camera.unproject(screenPos);
        return new Vector2(worldPos.x, worldPos.y);
    }

    public static void renderStar(ShapeRenderer renderer, float x, float y, Color color, float rotation, float radius) {
        Util.renderSquare(renderer, x, y, color, rotation, radius);
        Util.renderSquare(renderer, x, y, color, rotation + 45.0f, radius);
    }

    private static void renderSquare(ShapeRenderer renderer, float x, float y, Color color, float rotation, float radius) {
        float halfRadius = radius / 2.0f;
        renderer.setColor(color);
        renderer.rect(x - halfRadius, y - halfRadius, radius, radius, halfRadius, halfRadius, rotation);
    }
}

