/*
 * Decompiled with CFR 0.152.
 */
package walnoot.tag13;

import com.badlogic.gdx.ApplicationAdapter;
import com.badlogic.gdx.Gdx;
import com.badlogic.gdx.audio.Sound;
import walnoot.tag13.Assets;
import walnoot.tag13.Input;
import walnoot.tag13.Inputs;
import walnoot.tag13.states.GameState;
import walnoot.tag13.states.State;

public class TAG13Game
extends ApplicationAdapter {
    public static TAG13Game instance;
    private State state;
    private State newState;
    private float unprocessedSeconds;

    @Override
    public void create() {
        instance = this;
        Inputs.instance.addProcessor(Input.i);
        Gdx.input.setInputProcessor(Inputs.instance);
        Assets.manager.load("sounds/rain.wav", Sound.class);
        Assets.manager.load("sounds/thunder.wav", Sound.class);
        Assets.manager.finishLoading();
        Assets.manager.load("sounds/pickup.wav", Sound.class);
        this.setState(new GameState());
    }

    @Override
    public void render() {
        Assets.manager.update();
        this.unprocessedSeconds += Gdx.graphics.getDeltaTime();
        while (this.unprocessedSeconds > 0.016666668f) {
            this.unprocessedSeconds -= 0.016666668f;
            this.update();
        }
        Gdx.gl.glClearColor(1.0f, 1.0f, 1.0f, 1.0f);
        Gdx.gl.glClear(16384);
        this.state.render();
    }

    private void update() {
        if (this.newState != null) {
            if (this.state != null) {
                this.state.destroy();
            }
            this.state = this.newState;
            this.state.create();
            this.resize(Gdx.graphics.getWidth(), Gdx.graphics.getHeight());
            this.newState = null;
        }
        this.state.update();
        Input.i.update();
    }

    public void setState(State newState) {
        if (this.state == null) {
            this.state = newState;
            this.state.create();
            this.resize(Gdx.graphics.getWidth(), Gdx.graphics.getHeight());
        } else {
            this.newState = newState;
        }
    }

    public State getState() {
        return this.state;
    }

    @Override
    public void resize(int width, int height) {
        this.state.resize(width, height);
    }
}

