/*
 * Decompiled with CFR 0.152.
 */
package com.badlogic.gdx.utils.viewport;

import com.badlogic.gdx.graphics.Camera;
import com.badlogic.gdx.graphics.OrthographicCamera;
import com.badlogic.gdx.math.Vector2;
import com.badlogic.gdx.utils.Scaling;
import com.badlogic.gdx.utils.viewport.Viewport;

public class ExtendViewport
extends Viewport {
    private float minWorldWidth;
    private float minWorldHeight;
    private float maxWorldWidth;
    private float maxWorldHeight;

    public ExtendViewport(float minWorldWidth, float minWorldHeight) {
        this(minWorldWidth, minWorldHeight, 0.0f, 0.0f, new OrthographicCamera());
    }

    public ExtendViewport(float minWorldWidth, float minWorldHeight, Camera camera) {
        this(minWorldWidth, minWorldHeight, 0.0f, 0.0f, camera);
    }

    public ExtendViewport(float minWorldWidth, float minWorldHeight, float maxWorldWidth, float maxWorldHeight) {
        this(minWorldWidth, minWorldHeight, maxWorldWidth, maxWorldHeight, new OrthographicCamera());
    }

    public ExtendViewport(float minWorldWidth, float minWorldHeight, float maxWorldWidth, float maxWorldHeight, Camera camera) {
        this.minWorldWidth = minWorldWidth;
        this.minWorldHeight = minWorldHeight;
        this.maxWorldWidth = maxWorldWidth;
        this.maxWorldHeight = maxWorldHeight;
        this.camera = camera;
    }

    @Override
    public void update(int screenWidth, int screenHeight, boolean centerCamera) {
        this.worldWidth = this.minWorldWidth;
        this.worldHeight = this.minWorldHeight;
        Vector2 scaled = Scaling.fit.apply(this.worldWidth, this.worldHeight, screenWidth, screenHeight);
        this.viewportWidth = Math.round(scaled.x);
        this.viewportHeight = Math.round(scaled.y);
        if (this.viewportWidth < screenWidth) {
            float toViewportSpace = (float)this.viewportHeight / this.worldHeight;
            float toWorldSpace = this.worldHeight / (float)this.viewportHeight;
            float lengthen = (float)(screenWidth - this.viewportWidth) * toWorldSpace;
            if (this.maxWorldWidth > 0.0f) {
                lengthen = Math.min(lengthen, this.maxWorldWidth - this.minWorldWidth);
            }
            this.worldWidth += lengthen;
            this.viewportWidth += Math.round(lengthen * toViewportSpace);
        } else if (this.viewportHeight < screenHeight) {
            float toViewportSpace = (float)this.viewportWidth / this.worldWidth;
            float toWorldSpace = this.worldWidth / (float)this.viewportWidth;
            float lengthen = (float)(screenHeight - this.viewportHeight) * toWorldSpace;
            if (this.maxWorldHeight > 0.0f) {
                lengthen = Math.min(lengthen, this.maxWorldHeight - this.minWorldHeight);
            }
            this.worldHeight += lengthen;
            this.viewportHeight += Math.round(lengthen * toViewportSpace);
        }
        this.viewportX = (screenWidth - this.viewportWidth) / 2;
        this.viewportY = (screenHeight - this.viewportHeight) / 2;
        super.update(screenWidth, screenHeight, centerCamera);
    }

    public float getMinWorldWidth() {
        return this.minWorldWidth;
    }

    public void setMinWorldWidth(float minWorldWidth) {
        this.minWorldWidth = minWorldWidth;
    }

    public float getMinWorldHeight() {
        return this.minWorldHeight;
    }

    public void setMinWorldHeight(float minWorldHeight) {
        this.minWorldHeight = minWorldHeight;
    }

    public float getMaxWorldWidth() {
        return this.maxWorldWidth;
    }

    public void setMaxWorldWidth(float maxWorldWidth) {
        this.maxWorldWidth = maxWorldWidth;
    }

    public float getMaxWorldHeight() {
        return this.maxWorldHeight;
    }

    public void setMaxWorldHeight(float maxWorldHeight) {
        this.maxWorldHeight = maxWorldHeight;
    }
}

