/*
 * Decompiled with CFR 0.152.
 */
package com.badlogic.gdx.utils;

import com.badlogic.gdx.utils.Array;
import com.badlogic.gdx.utils.ObjectMap;
import com.badlogic.gdx.utils.StringBuilder;

public class OrderedMap<K, V>
extends ObjectMap<K, V> {
    final Array<K> keys;

    public OrderedMap() {
        this.keys = new Array();
    }

    public OrderedMap(int initialCapacity) {
        super(initialCapacity);
        this.keys = new Array(this.capacity);
    }

    public OrderedMap(int initialCapacity, float loadFactor) {
        super(initialCapacity, loadFactor);
        this.keys = new Array(this.capacity);
    }

    public OrderedMap(ObjectMap<? extends K, ? extends V> map) {
        super(map);
        this.keys = new Array(this.capacity);
    }

    @Override
    public V put(K key, V value) {
        if (!this.containsKey(key)) {
            this.keys.add(key);
        }
        return super.put(key, value);
    }

    @Override
    public V remove(K key) {
        this.keys.removeValue(key, false);
        return super.remove(key);
    }

    @Override
    public void clear(int maximumCapacity) {
        this.keys.clear();
        super.clear(maximumCapacity);
    }

    @Override
    public void clear() {
        this.keys.clear();
        super.clear();
    }

    public Array<K> orderedKeys() {
        return this.keys;
    }

    @Override
    public ObjectMap.Entries<K, V> entries() {
        return new ObjectMap.Entries(this){

            @Override
            void advance() {
                ++this.nextIndex;
                this.hasNext = this.nextIndex < this.map.size;
            }

            @Override
            public ObjectMap.Entry next() {
                this.entry.key = OrderedMap.this.keys.get(this.nextIndex);
                this.entry.value = this.map.get(this.entry.key);
                this.advance();
                return this.entry;
            }

            @Override
            public void remove() {
                this.map.remove(this.entry.key);
            }
        };
    }

    @Override
    public ObjectMap.Keys<K> keys() {
        return new ObjectMap.Keys(this){

            @Override
            void advance() {
                ++this.nextIndex;
                this.hasNext = this.nextIndex < this.map.size;
            }

            @Override
            public K next() {
                Object key = OrderedMap.this.keys.get(this.nextIndex);
                this.advance();
                return key;
            }

            @Override
            public void remove() {
                this.map.remove(OrderedMap.this.keys.get(this.nextIndex - 1));
            }
        };
    }

    @Override
    public ObjectMap.Values<V> values() {
        return new ObjectMap.Values(this){

            @Override
            void advance() {
                ++this.nextIndex;
                this.hasNext = this.nextIndex < this.map.size;
            }

            @Override
            public V next() {
                Object value = this.map.get(OrderedMap.this.keys.get(this.nextIndex));
                this.advance();
                return value;
            }

            @Override
            public void remove() {
                this.map.remove(OrderedMap.this.keys.get(this.nextIndex - 1));
            }
        };
    }

    @Override
    public String toString() {
        if (this.size == 0) {
            return "{}";
        }
        StringBuilder buffer = new StringBuilder(32);
        buffer.append('{');
        Array<K> keys = this.keys;
        int n = keys.size;
        for (int i = 0; i < n; ++i) {
            K key = keys.get(i);
            if (i > 0) {
                buffer.append(", ");
            }
            buffer.append(key);
            buffer.append('=');
            buffer.append(this.get(key));
        }
        buffer.append('}');
        return buffer.toString();
    }
}

