/*
 * Decompiled with CFR 0.152.
 */
package com.badlogic.gdx.utils;

import com.badlogic.gdx.files.FileHandle;
import com.badlogic.gdx.utils.Array;
import com.badlogic.gdx.utils.BaseJsonReader;
import com.badlogic.gdx.utils.JsonValue;
import com.badlogic.gdx.utils.SerializationException;
import com.badlogic.gdx.utils.StreamUtils;
import com.badlogic.gdx.utils.StringBuilder;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;

public class JsonReader
implements BaseJsonReader {
    private static final byte[] _json_actions = JsonReader.init__json_actions_0();
    private static final short[] _json_key_offsets = JsonReader.init__json_key_offsets_0();
    private static final char[] _json_trans_keys = JsonReader.init__json_trans_keys_0();
    private static final byte[] _json_single_lengths = JsonReader.init__json_single_lengths_0();
    private static final byte[] _json_range_lengths = JsonReader.init__json_range_lengths_0();
    private static final short[] _json_index_offsets = JsonReader.init__json_index_offsets_0();
    private static final byte[] _json_trans_targs = JsonReader.init__json_trans_targs_0();
    private static final byte[] _json_trans_actions = JsonReader.init__json_trans_actions_0();
    private static final byte[] _json_eof_actions = JsonReader.init__json_eof_actions_0();
    static final int json_start = 1;
    static final int json_first_final = 57;
    static final int json_error = 0;
    static final int json_en_object = 10;
    static final int json_en_array = 41;
    static final int json_en_main = 1;
    private final Array<JsonValue> elements = new Array(8);
    private final Array<JsonValue> lastChild = new Array(8);
    private JsonValue root;
    private JsonValue current;

    public JsonValue parse(String json) {
        char[] data = json.toCharArray();
        return this.parse(data, 0, data.length);
    }

    public JsonValue parse(Reader reader) {
        try {
            int length;
            char[] data = new char[1024];
            int offset = 0;
            while ((length = reader.read(data, offset, data.length - offset)) != -1) {
                if (length == 0) {
                    char[] newData = new char[data.length * 2];
                    System.arraycopy(data, 0, newData, 0, data.length);
                    data = newData;
                    continue;
                }
                offset += length;
            }
            JsonValue jsonValue = this.parse(data, 0, offset);
            return jsonValue;
        }
        catch (IOException ex) {
            throw new SerializationException(ex);
        }
        finally {
            StreamUtils.closeQuietly(reader);
        }
    }

    @Override
    public JsonValue parse(InputStream input) {
        try {
            JsonValue jsonValue = this.parse(new InputStreamReader(input, "UTF-8"));
            return jsonValue;
        }
        catch (IOException ex) {
            throw new SerializationException(ex);
        }
        finally {
            StreamUtils.closeQuietly(input);
        }
    }

    @Override
    public JsonValue parse(FileHandle file) {
        try {
            return this.parse(file.reader("UTF-8"));
        }
        catch (Exception ex) {
            throw new SerializationException("Error parsing file: " + file, ex);
        }
    }

    /*
     * Unable to fully structure code
     */
    public JsonValue parse(char[] data, int offset, int length) {
        p = offset;
        eof = pe = length;
        top = 0;
        stack = new int[4];
        s = 0;
        names = new Array<String>(8);
        needsUnescape = false;
        parseRuntimeEx = null;
        debug = false;
        if (debug) {
            System.out.println();
        }
        try {
            cs = 1;
            top = 0;
            _trans = 0;
            _goto_targ = 0;
            block31: while (true) {
                switch (_goto_targ) {
                    case 0: {
                        if (p == pe) {
                            _goto_targ = 4;
                            continue block31;
                        }
                        if (cs == 0) {
                            _goto_targ = 5;
                            continue block31;
                        }
                    }
                    case 1: {
                        _keys = JsonReader._json_key_offsets[cs];
                        _trans = JsonReader._json_index_offsets[cs];
                        _klen = JsonReader._json_single_lengths[cs];
                        if (_klen <= 0) ** GOTO lbl45
                        _lower = _keys;
                        _upper = _keys + _klen - 1;
                        while (_upper >= _lower) {
                            _mid = _lower + (_upper - _lower >> 1);
                            if (data[p] < JsonReader._json_trans_keys[_mid]) {
                                _upper = _mid - 1;
                                continue;
                            }
                            if (data[p] > JsonReader._json_trans_keys[_mid]) {
                                _lower = _mid + 1;
                                continue;
                            }
                            _trans += _mid - _keys;
                            ** GOTO lbl59
                        }
                        _keys += _klen;
                        _trans += _klen;
lbl45:
                        // 2 sources

                        if ((_klen = JsonReader._json_range_lengths[cs]) > 0) {
                            _lower = _keys;
                            _upper = _keys + (_klen << 1) - 2;
                            while (_upper >= _lower) {
                                _mid = _lower + (_upper - _lower >> 1 & -2);
                                if (data[p] < JsonReader._json_trans_keys[_mid]) {
                                    _upper = _mid - 2;
                                    continue;
                                }
                                if (data[p] > JsonReader._json_trans_keys[_mid + 1]) {
                                    _lower = _mid + 2;
                                    continue;
                                }
                                _trans += _mid - _keys >> 1;
                                ** GOTO lbl59
                            }
                            _trans += _klen;
                        }
lbl59:
                        // 5 sources

                        cs = JsonReader._json_trans_targs[_trans];
                        if (JsonReader._json_trans_actions[_trans] != 0) {
                            _acts = JsonReader._json_trans_actions[_trans];
                            _nacts = JsonReader._json_actions[_acts++];
                            block34: while (_nacts-- > 0) {
                                switch (JsonReader._json_actions[_acts++]) {
                                    case 0: {
                                        s = p;
                                        needsUnescape = false;
                                        break;
                                    }
                                    case 1: {
                                        needsUnescape = true;
                                        break;
                                    }
                                    case 2: {
                                        name = new String(data, s, p - s);
                                        s = p;
                                        if (needsUnescape) {
                                            name = this.unescape(name);
                                        }
                                        if (debug) {
                                            System.out.println("name: " + name);
                                        }
                                        names.add(name);
                                        break;
                                    }
                                    case 3: {
                                        value = new String(data, s, p - s);
                                        s = p;
                                        if (needsUnescape) {
                                            value = this.unescape(value);
                                        }
                                        v0 = name = names.size > 0 ? (String)names.pop() : null;
                                        if (debug) {
                                            System.out.println("string: " + name + "=" + value);
                                        }
                                        this.string(name, value);
                                        break;
                                    }
                                    case 4: {
                                        value = new String(data, s, p - s);
                                        s = p;
                                        v1 = name = names.size > 0 ? (String)names.pop() : null;
                                        if (debug) {
                                            System.out.println("double: " + name + "=" + Double.parseDouble(value));
                                        }
                                        this.number(name, Double.parseDouble(value));
                                        break;
                                    }
                                    case 5: {
                                        value = new String(data, s, p - s);
                                        s = p;
                                        v2 = name = names.size > 0 ? (String)names.pop() : null;
                                        if (debug) {
                                            System.out.println("long: " + name + "=" + Long.parseLong(value));
                                        }
                                        this.number(name, Long.parseLong(value));
                                        break;
                                    }
                                    case 6: {
                                        v3 = name = names.size > 0 ? (String)names.pop() : null;
                                        if (debug) {
                                            System.out.println("startObject: " + name);
                                        }
                                        this.startObject(name);
                                        if (top == stack.length) {
                                            newStack = new int[stack.length * 2];
                                            System.arraycopy(stack, 0, newStack, 0, stack.length);
                                            stack = newStack;
                                        }
                                        stack[top++] = cs;
                                        cs = 10;
                                        _goto_targ = 2;
                                        continue block31;
                                    }
                                    case 7: {
                                        if (debug) {
                                            System.out.println("endObject");
                                        }
                                        this.pop();
                                        cs = stack[--top];
                                        _goto_targ = 2;
                                        continue block31;
                                    }
                                    case 8: {
                                        v4 = name = names.size > 0 ? (String)names.pop() : null;
                                        if (debug) {
                                            System.out.println("startArray: " + name);
                                        }
                                        this.startArray(name);
                                        if (top == stack.length) {
                                            newStack = new int[stack.length * 2];
                                            System.arraycopy(stack, 0, newStack, 0, stack.length);
                                            stack = newStack;
                                        }
                                        stack[top++] = cs;
                                        cs = 41;
                                        _goto_targ = 2;
                                        continue block31;
                                    }
                                    case 9: {
                                        if (debug) {
                                            System.out.println("endArray");
                                        }
                                        this.pop();
                                        cs = stack[--top];
                                        _goto_targ = 2;
                                        continue block31;
                                    }
                                    case 10: {
                                        if (debug) {
                                            System.out.println("comment /" + data[p]);
                                        }
                                        if (data[p++] == '/') {
                                            while (data[p] != '\n') {
                                                ++p;
                                            }
                                            continue block34;
                                        }
                                        while (data[p] != '*' || data[p + 1] != '/') {
                                            ++p;
                                        }
                                        ++p;
                                        break;
                                    }
                                    case 11: {
                                        block37: while (true) {
                                            switch (data[p]) {
                                                case '\t': 
                                                case '\n': 
                                                case '\r': 
                                                case ' ': 
                                                case ',': 
                                                case ':': 
                                                case ']': 
                                                case '}': {
                                                    break block37;
                                                }
                                                default: {
                                                    ++p;
                                                    continue block37;
                                                }
                                            }
                                            break;
                                        }
                                        --p;
                                        break;
                                    }
                                    case 12: {
                                        value = new String(data, s, p - s);
                                        s = p;
                                        v5 = name = names.size > 0 ? (String)names.pop() : null;
                                        if (value.equals("null")) {
                                            if (debug) {
                                                System.out.println("null: " + name);
                                            }
                                            this.string(name, null);
                                            break;
                                        }
                                        if (value.equals("true")) {
                                            if (debug) {
                                                System.out.println("boolean: " + name + "=true");
                                            }
                                            this.bool(name, true);
                                            break;
                                        }
                                        if (value.equals("false")) {
                                            if (debug) {
                                                System.out.println("boolean: " + name + "=false");
                                            }
                                            this.bool(name, false);
                                            break;
                                        }
                                        if (needsUnescape) {
                                            value = this.unescape(value);
                                        }
                                        if (debug) {
                                            System.out.println("unquotedString: " + name + "=" + value);
                                        }
                                        this.string(name, value);
                                    }
                                }
                            }
                        }
                    }
                    case 2: {
                        if (cs == 0) {
                            _goto_targ = 5;
                            continue block31;
                        }
                        if (++p != pe) {
                            _goto_targ = 1;
                            continue block31;
                        }
                    }
                    case 4: {
                        if (p != eof) break block31;
                        __acts = JsonReader._json_eof_actions[cs];
                        __nacts = JsonReader._json_actions[__acts++];
                        while (__nacts-- > 0) {
                            switch (JsonReader._json_actions[__acts++]) {
                                case 4: {
                                    value = new String(data, s, p - s);
                                    s = p;
                                    v6 = name = names.size > 0 ? (String)names.pop() : null;
                                    if (debug) {
                                        System.out.println("double: " + name + "=" + Double.parseDouble(value));
                                    }
                                    this.number(name, Double.parseDouble(value));
                                    break;
                                }
                                case 5: {
                                    value = new String(data, s, p - s);
                                    s = p;
                                    v7 = name = names.size > 0 ? (String)names.pop() : null;
                                    if (debug) {
                                        System.out.println("long: " + name + "=" + Long.parseLong(value));
                                    }
                                    this.number(name, Long.parseLong(value));
                                    break;
                                }
                                case 12: {
                                    value = new String(data, s, p - s);
                                    s = p;
                                    v8 = name = names.size > 0 ? (String)names.pop() : null;
                                    if (value.equals("null")) {
                                        if (debug) {
                                            System.out.println("null: " + name);
                                        }
                                        this.string(name, null);
                                        break;
                                    }
                                    if (value.equals("true")) {
                                        if (debug) {
                                            System.out.println("boolean: " + name + "=true");
                                        }
                                        this.bool(name, true);
                                        break;
                                    }
                                    if (value.equals("false")) {
                                        if (debug) {
                                            System.out.println("boolean: " + name + "=false");
                                        }
                                        this.bool(name, false);
                                        break;
                                    }
                                    if (needsUnescape) {
                                        value = this.unescape(value);
                                    }
                                    if (debug) {
                                        System.out.println("unquotedString: " + name + "=" + value);
                                    }
                                    this.string(name, value);
                                }
                            }
                        }
                        break block31;
                    }
                }
                break;
            }
        }
        catch (RuntimeException ex) {
            parseRuntimeEx = ex;
        }
        root = this.root;
        this.root = null;
        this.current = null;
        this.lastChild.clear();
        if (p < pe) {
            lineNumber = 1;
            for (i = 0; i < p; ++i) {
                if (data[i] != '\n') continue;
                ++lineNumber;
            }
            throw new SerializationException("Error parsing JSON on line " + lineNumber + " near: " + new String(data, p, pe - p), parseRuntimeEx);
        }
        if (this.elements.size != 0) {
            element = this.elements.peek();
            this.elements.clear();
            if (element != null && element.isObject()) {
                throw new SerializationException("Error parsing JSON, unmatched brace.");
            }
            throw new SerializationException("Error parsing JSON, unmatched bracket.");
        }
        if (parseRuntimeEx != null) {
            throw new SerializationException("Error parsing JSON: " + new String(data), parseRuntimeEx);
        }
        return root;
    }

    private static byte[] init__json_actions_0() {
        return new byte[]{0, 1, 0, 1, 1, 1, 2, 1, 3, 1, 4, 1, 5, 1, 6, 1, 7, 1, 8, 1, 9, 1, 10, 1, 12, 2, 0, 2, 2, 0, 3, 2, 0, 11, 2, 4, 7, 2, 4, 9, 2, 5, 7, 2, 5, 9, 2, 12, 7, 2, 12, 9};
    }

    private static short[] init__json_key_offsets_0() {
        return new short[]{0, 0, 16, 18, 20, 22, 31, 33, 37, 39, 41, 57, 59, 61, 66, 68, 84, 86, 88, 94, 109, 114, 116, 119, 128, 132, 134, 141, 143, 151, 153, 162, 168, 170, 179, 189, 193, 195, 203, 205, 214, 216, 234, 236, 238, 244, 261, 267, 269, 271, 280, 290, 294, 296, 304, 306, 315, 317, 321, 325, 332, 340, 346, 346};
    }

    private static char[] init__json_trans_keys_0() {
        return new char[]{' ', '\"', '$', '-', '/', '[', '_', '{', '\t', '\r', '0', '9', 'A', 'Z', 'a', 'z', '\"', '\\', '\"', '\\', '*', '/', '\"', '/', '\\', 'b', 'f', 'n', 'r', 't', 'u', '0', '9', '+', '-', '0', '9', '0', '9', '*', '/', ' ', '\"', '$', ',', '-', '/', '_', '}', '\t', '\r', '0', '9', 'A', 'Z', 'a', 'z', '\"', '\\', '\"', '\\', ' ', '/', ':', '\t', '\r', '*', '/', ' ', '\"', '$', '-', '/', '[', '_', '{', '\t', '\r', '0', '9', 'A', 'Z', 'a', 'z', '\"', '\\', '\"', '\\', ' ', ',', '/', '}', '\t', '\r', ' ', '\"', '$', '-', '/', '_', '}', '\t', '\r', '0', '9', 'A', 'Z', 'a', 'z', ' ', '/', ':', '\t', '\r', '0', '9', '.', '0', '9', ' ', '/', ':', 'E', 'e', '\t', '\r', '0', '9', '+', '-', '0', '9', '0', '9', ' ', '/', ':', '\t', '\r', '0', '9', '*', '/', ' ', '.', '/', ':', '\t', '\r', '0', '9', '*', '/', '\"', '/', '\\', 'b', 'f', 'n', 'r', 't', 'u', ' ', ',', '/', '}', '\t', '\r', '0', '9', ' ', ',', '.', '/', '}', '\t', '\r', '0', '9', ' ', ',', '/', 'E', 'e', '}', '\t', '\r', '0', '9', '+', '-', '0', '9', '0', '9', ' ', ',', '/', '}', '\t', '\r', '0', '9', '*', '/', '\"', '/', '\\', 'b', 'f', 'n', 'r', 't', 'u', '*', '/', ' ', '\"', '$', ',', '-', '/', '[', ']', '_', '{', '\t', '\r', '0', '9', 'A', 'Z', 'a', 'z', '\"', '\\', '\"', '\\', ' ', ',', '/', ']', '\t', '\r', ' ', '\"', '$', '-', '/', '[', ']', '_', '{', '\t', '\r', '0', '9', 'A', 'Z', 'a', 'z', ' ', ',', '/', ']', '\t', '\r', '*', '/', '0', '9', ' ', ',', '.', '/', ']', '\t', '\r', '0', '9', ' ', ',', '/', 'E', ']', 'e', '\t', '\r', '0', '9', '+', '-', '0', '9', '0', '9', ' ', ',', '/', ']', '\t', '\r', '0', '9', '*', '/', '\"', '/', '\\', 'b', 'f', 'n', 'r', 't', 'u', '*', '/', ' ', '/', '\t', '\r', ' ', '/', '\t', '\r', ' ', '.', '/', '\t', '\r', '0', '9', ' ', '/', 'E', 'e', '\t', '\r', '0', '9', ' ', '/', '\t', '\r', '0', '9', '\u0000'};
    }

    private static byte[] init__json_single_lengths_0() {
        return new byte[]{0, 8, 2, 2, 2, 7, 0, 2, 0, 2, 8, 2, 2, 3, 2, 8, 2, 2, 4, 7, 3, 0, 1, 5, 2, 0, 3, 2, 4, 2, 7, 4, 0, 5, 6, 2, 0, 4, 2, 7, 2, 10, 2, 2, 4, 9, 4, 2, 0, 5, 6, 2, 0, 4, 2, 7, 2, 2, 2, 3, 4, 2, 0, 0};
    }

    private static byte[] init__json_range_lengths_0() {
        return new byte[]{0, 4, 0, 0, 0, 1, 1, 1, 1, 0, 4, 0, 0, 1, 0, 4, 0, 0, 1, 4, 1, 1, 1, 2, 1, 1, 2, 0, 2, 0, 1, 1, 1, 2, 2, 1, 1, 2, 0, 1, 0, 4, 0, 0, 1, 4, 1, 0, 1, 2, 2, 1, 1, 2, 0, 1, 0, 1, 1, 2, 2, 2, 0, 0};
    }

    private static short[] init__json_index_offsets_0() {
        return new short[]{0, 0, 13, 16, 19, 22, 31, 33, 37, 39, 42, 55, 58, 61, 66, 69, 82, 85, 88, 94, 106, 111, 113, 116, 124, 128, 130, 136, 139, 146, 149, 158, 164, 166, 174, 183, 187, 189, 196, 199, 208, 211, 226, 229, 232, 238, 252, 258, 261, 263, 271, 280, 284, 286, 293, 296, 305, 308, 312, 316, 322, 329, 334, 335};
    }

    private static byte[] init__json_trans_targs_0() {
        return new byte[]{1, 2, 58, 6, 9, 57, 58, 57, 1, 59, 58, 58, 0, 57, 5, 3, 57, 5, 3, 57, 57, 0, 3, 3, 3, 3, 3, 3, 3, 3, 0, 59, 0, 8, 8, 61, 0, 61, 0, 1, 1, 0, 10, 11, 20, 19, 21, 40, 20, 62, 10, 28, 20, 20, 0, 13, 39, 12, 13, 39, 12, 13, 14, 15, 13, 0, 13, 13, 0, 15, 16, 31, 32, 38, 18, 31, 18, 15, 33, 31, 31, 0, 18, 30, 17, 18, 30, 17, 18, 19, 29, 62, 18, 0, 19, 11, 20, 21, 27, 20, 62, 19, 28, 20, 20, 0, 13, 14, 15, 13, 0, 22, 0, 23, 22, 0, 13, 14, 15, 24, 24, 13, 23, 0, 25, 25, 26, 0, 26, 0, 13, 14, 15, 13, 26, 0, 19, 19, 0, 13, 23, 14, 15, 13, 22, 0, 18, 18, 0, 17, 17, 17, 17, 17, 17, 17, 17, 0, 18, 19, 29, 62, 18, 0, 33, 0, 18, 19, 34, 29, 62, 18, 33, 0, 18, 19, 29, 35, 35, 62, 18, 34, 0, 36, 36, 37, 0, 37, 0, 18, 19, 29, 62, 18, 37, 0, 15, 15, 0, 12, 12, 12, 12, 12, 12, 12, 12, 0, 10, 10, 0, 41, 42, 46, 45, 48, 56, 44, 63, 46, 44, 41, 49, 46, 46, 0, 44, 55, 43, 44, 55, 43, 44, 45, 47, 63, 44, 0, 45, 42, 46, 48, 54, 44, 63, 46, 44, 45, 49, 46, 46, 0, 44, 45, 47, 63, 44, 0, 44, 44, 0, 49, 0, 44, 45, 50, 47, 63, 44, 49, 0, 44, 45, 47, 51, 63, 51, 44, 50, 0, 52, 52, 53, 0, 53, 0, 44, 45, 47, 63, 44, 53, 0, 45, 45, 0, 43, 43, 43, 43, 43, 43, 43, 43, 0, 41, 41, 0, 57, 4, 57, 0, 57, 4, 57, 0, 57, 60, 4, 57, 59, 0, 57, 4, 7, 7, 57, 60, 0, 57, 4, 57, 61, 0, 0, 0, 0};
    }

    private static byte[] init__json_trans_actions_0() {
        return new byte[]{0, 0, 31, 1, 0, 17, 31, 13, 0, 1, 31, 31, 0, 28, 1, 1, 7, 0, 0, 21, 21, 0, 3, 3, 3, 3, 3, 3, 3, 3, 0, 0, 0, 0, 0, 0, 0, 0, 0, 21, 21, 0, 0, 0, 31, 0, 1, 0, 31, 15, 0, 31, 31, 31, 0, 25, 1, 1, 5, 0, 0, 0, 0, 0, 0, 0, 21, 21, 0, 0, 0, 31, 1, 0, 17, 31, 13, 0, 1, 31, 31, 0, 28, 1, 1, 7, 0, 0, 0, 0, 0, 15, 0, 0, 0, 0, 31, 1, 0, 31, 15, 0, 31, 31, 31, 0, 5, 5, 5, 5, 0, 0, 0, 0, 0, 0, 5, 5, 5, 0, 0, 5, 0, 0, 0, 0, 0, 0, 0, 0, 5, 5, 5, 5, 0, 0, 21, 21, 0, 5, 0, 5, 5, 5, 0, 0, 21, 21, 0, 3, 3, 3, 3, 3, 3, 3, 3, 0, 23, 23, 23, 46, 23, 0, 0, 0, 11, 11, 0, 11, 40, 11, 0, 0, 9, 9, 9, 0, 0, 34, 9, 0, 0, 0, 0, 0, 0, 0, 0, 9, 9, 9, 34, 9, 0, 0, 21, 21, 0, 3, 3, 3, 3, 3, 3, 3, 3, 0, 21, 21, 0, 0, 0, 31, 0, 1, 0, 17, 19, 31, 13, 0, 1, 31, 31, 0, 28, 1, 1, 7, 0, 0, 0, 0, 0, 19, 0, 0, 0, 0, 31, 1, 0, 17, 19, 31, 13, 0, 1, 31, 31, 0, 23, 23, 23, 49, 23, 0, 21, 21, 0, 0, 0, 11, 11, 0, 11, 43, 11, 0, 0, 9, 9, 9, 0, 37, 0, 9, 0, 0, 0, 0, 0, 0, 0, 0, 9, 9, 9, 37, 9, 0, 0, 21, 21, 0, 3, 3, 3, 3, 3, 3, 3, 3, 0, 21, 21, 0, 0, 0, 0, 0, 23, 23, 23, 0, 11, 0, 11, 11, 0, 0, 9, 9, 0, 0, 9, 0, 0, 9, 9, 9, 0, 0, 0, 0, 0};
    }

    private static byte[] init__json_eof_actions_0() {
        return new byte[]{0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 23, 11, 9, 9, 0, 0};
    }

    private void addChild(String name, JsonValue child) {
        child.setName(name);
        if (this.current == null) {
            this.current = child;
            this.root = child;
        } else if (this.current.isArray() || this.current.isObject()) {
            if (this.current.size == 0) {
                this.current.child = child;
            } else {
                JsonValue last = this.lastChild.pop();
                last.next = child;
                child.prev = last;
            }
            this.lastChild.add(child);
            ++this.current.size;
        } else {
            this.root = this.current;
        }
    }

    protected void startObject(String name) {
        JsonValue value = new JsonValue(JsonValue.ValueType.object);
        if (this.current != null) {
            this.addChild(name, value);
        }
        this.elements.add(value);
        this.current = value;
    }

    protected void startArray(String name) {
        JsonValue value = new JsonValue(JsonValue.ValueType.array);
        if (this.current != null) {
            this.addChild(name, value);
        }
        this.elements.add(value);
        this.current = value;
    }

    protected void pop() {
        this.root = this.elements.pop();
        if (this.current.size > 0) {
            this.lastChild.pop();
        }
        this.current = this.elements.size > 0 ? this.elements.peek() : null;
    }

    protected void string(String name, String value) {
        this.addChild(name, new JsonValue(value));
    }

    protected void number(String name, double value) {
        this.addChild(name, new JsonValue(value));
    }

    protected void number(String name, long value) {
        this.addChild(name, new JsonValue(value));
    }

    protected void bool(String name, boolean value) {
        this.addChild(name, new JsonValue(value));
    }

    private String unescape(String value) {
        int length = value.length();
        StringBuilder buffer = new StringBuilder(length + 16);
        int i = 0;
        while (i < length) {
            char c;
            if ((c = value.charAt(i++)) != '\\') {
                buffer.append(c);
                continue;
            }
            if (i == length) break;
            if ((c = value.charAt(i++)) == 'u') {
                buffer.append(Character.toChars(Integer.parseInt(value.substring(i, i + 4), 16)));
                i += 4;
                continue;
            }
            switch (c) {
                case '\"': 
                case '/': 
                case '\\': {
                    break;
                }
                case 'b': {
                    c = '\b';
                    break;
                }
                case 'f': {
                    c = '\f';
                    break;
                }
                case 'n': {
                    c = '\n';
                    break;
                }
                case 'r': {
                    c = '\r';
                    break;
                }
                case 't': {
                    c = '\t';
                    break;
                }
                default: {
                    throw new SerializationException("Illegal escaped character: \\" + c);
                }
            }
            buffer.append(c);
        }
        return buffer.toString();
    }
}

