/*
 * Decompiled with CFR 0.152.
 */
package com.badlogic.gdx.math;

import com.badlogic.gdx.math.Vector2;
import java.io.Serializable;

public class Rectangle
implements Serializable {
    public static final Rectangle tmp = new Rectangle();
    public static final Rectangle tmp2 = new Rectangle();
    private static final long serialVersionUID = 5733252015138115702L;
    public float x;
    public float y;
    public float width;
    public float height;

    public Rectangle() {
    }

    public Rectangle(float x, float y, float width, float height) {
        this.x = x;
        this.y = y;
        this.width = width;
        this.height = height;
    }

    public Rectangle(Rectangle rect) {
        this.x = rect.x;
        this.y = rect.y;
        this.width = rect.width;
        this.height = rect.height;
    }

    public Rectangle set(float x, float y, float width, float height) {
        this.x = x;
        this.y = y;
        this.width = width;
        this.height = height;
        return this;
    }

    public float getX() {
        return this.x;
    }

    public Rectangle setX(float x) {
        this.x = x;
        return this;
    }

    public float getY() {
        return this.y;
    }

    public Rectangle setY(float y) {
        this.y = y;
        return this;
    }

    public float getWidth() {
        return this.width;
    }

    public Rectangle setWidth(float width) {
        this.width = width;
        return this;
    }

    public float getHeight() {
        return this.height;
    }

    public Rectangle setHeight(float height) {
        this.height = height;
        return this;
    }

    public Vector2 getPosition(Vector2 position) {
        return position.set(this.x, this.y);
    }

    public Rectangle setPosition(Vector2 position) {
        this.x = position.x;
        this.y = position.y;
        return this;
    }

    public Rectangle setPosition(float x, float y) {
        this.x = x;
        this.y = y;
        return this;
    }

    public Rectangle setSize(float width, float height) {
        this.width = width;
        this.height = height;
        return this;
    }

    public Rectangle setSize(float sizeXY) {
        this.width = sizeXY;
        this.height = sizeXY;
        return this;
    }

    public Vector2 getSize(Vector2 size) {
        return size.set(this.width, this.height);
    }

    public boolean contains(float x, float y) {
        return this.x <= x && this.x + this.width >= x && this.y <= y && this.y + this.height >= y;
    }

    public boolean contains(Vector2 point) {
        return this.contains(point.x, point.y);
    }

    public boolean contains(Rectangle rectangle) {
        float xmin = rectangle.x;
        float xmax = xmin + rectangle.width;
        float ymin = rectangle.y;
        float ymax = ymin + rectangle.height;
        return xmin > this.x && xmin < this.x + this.width && xmax > this.x && xmax < this.x + this.width && ymin > this.y && ymin < this.y + this.height && ymax > this.y && ymax < this.y + this.height;
    }

    public boolean overlaps(Rectangle r) {
        return this.x < r.x + r.width && this.x + this.width > r.x && this.y < r.y + r.height && this.y + this.height > r.y;
    }

    public Rectangle set(Rectangle rect) {
        this.x = rect.x;
        this.y = rect.y;
        this.width = rect.width;
        this.height = rect.height;
        return this;
    }

    public Rectangle merge(Rectangle rect) {
        float minX = Math.min(this.x, rect.x);
        float maxX = Math.max(this.x + this.width, rect.x + rect.width);
        this.x = minX;
        this.width = maxX - minX;
        float minY = Math.min(this.y, rect.y);
        float maxY = Math.max(this.y + this.height, rect.y + rect.height);
        this.y = minY;
        this.height = maxY - minY;
        return this;
    }

    public float getAspectRatio() {
        return this.height == 0.0f ? Float.NaN : this.width / this.height;
    }

    public Vector2 getCenter(Vector2 vector) {
        vector.x = this.x + this.width / 2.0f;
        vector.y = this.y + this.height / 2.0f;
        return vector;
    }

    public Rectangle setCenter(float x, float y) {
        this.setPosition(x - this.width / 2.0f, y - this.height / 2.0f);
        return this;
    }

    public Rectangle setCenter(Vector2 position) {
        this.setPosition(position.x - this.width / 2.0f, position.y - this.height / 2.0f);
        return this;
    }

    public Rectangle fitOutside(Rectangle rect) {
        float ratio = this.getAspectRatio();
        if (ratio > rect.getAspectRatio()) {
            this.setSize(rect.height * ratio, rect.height);
        } else {
            this.setSize(rect.width, rect.width / ratio);
        }
        this.setPosition(rect.x + rect.width / 2.0f - this.width / 2.0f, rect.y + rect.height / 2.0f - this.height / 2.0f);
        return this;
    }

    public Rectangle fitInside(Rectangle rect) {
        float ratio = this.getAspectRatio();
        if (ratio < rect.getAspectRatio()) {
            this.setSize(rect.height * ratio, rect.height);
        } else {
            this.setSize(rect.width, rect.width / ratio);
        }
        this.setPosition(rect.x + rect.width / 2.0f - this.width / 2.0f, rect.y + rect.height / 2.0f - this.height / 2.0f);
        return this;
    }

    public String toString() {
        return this.x + "," + this.y + "," + this.width + "," + this.height;
    }
}

