/*
 * Decompiled with CFR 0.152.
 */
package walnoot.swarm.screens;

import com.badlogic.gdx.Gdx;
import com.badlogic.gdx.scenes.scene2d.Actor;
import com.badlogic.gdx.scenes.scene2d.Stage;
import com.badlogic.gdx.scenes.scene2d.ui.Image;
import com.badlogic.gdx.scenes.scene2d.ui.Table;
import com.badlogic.gdx.scenes.scene2d.ui.TextButton;
import com.badlogic.gdx.scenes.scene2d.utils.ChangeListener;
import walnoot.swarm.Util;
import walnoot.swarm.screens.GameScreen;
import walnoot.swarm.screens.UpdateScreen;

public class MainMenu
extends UpdateScreen {
    private Stage stage;

    @Override
    public void show() {
        this.stage = new Stage();
        this.game.addInputProcessor(this.stage);
        Table table = new Table();
        table.setFillParent(true);
        this.stage.addActor(table);
        table.add(new Image(Util.atlas.findRegion("logo"))).pad(4.0f).row();
        final String level = Gdx.app.getPreferences("Swarm").getString("currentLevel", "level1");
        TextButton newGameButton = new TextButton("New Game", Util.skin);
        newGameButton.addListener(new ChangeListener(){

            @Override
            public void changed(ChangeListener.ChangeEvent event, Actor actor) {
                MainMenu.this.game.setScreen(new GameScreen("level1"));
            }
        });
        newGameButton.addListener(Util.CLICK_LISTENER);
        table.add(newGameButton).fill().pad(4.0f).row();
        TextButton continueGameButton = new TextButton("Continue Game", Util.skin);
        continueGameButton.addListener(new ChangeListener(){

            @Override
            public void changed(ChangeListener.ChangeEvent event, Actor actor) {
                MainMenu.this.game.setScreen(new GameScreen(level));
            }
        });
        continueGameButton.addListener(Util.CLICK_LISTENER);
        table.add(continueGameButton).fill().pad(4.0f).row();
    }

    @Override
    public void render(float delta) {
        Gdx.gl20.glClearColor(1.0f, 1.0f, 1.0f, 1.0f);
        Gdx.gl20.glClear(16384);
        this.stage.draw();
        this.stage.act();
    }

    @Override
    public void resize(int width, int height) {
        this.stage.setViewport(width, height);
    }
}

